/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.scripthandler.rhino;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.scripthandler.rhino.RhinoScriptHandler;
import com.adobe.xfa.scripthandler.rhino.ScriptObject;
import com.adobe.xfa.ut.ExFull;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class LiveObject
extends ScriptableObject {
    static final long serialVersionUID = 4351208801270519263L;
    public static final String CLASSNAME = "XFAObject";
    private static final Method mInvokeMethod;
    protected transient RhinoScriptHandler moHandler;
    protected transient ScriptObject moScriptObj;
    protected transient Obj moXFAObject;

    public LiveObject(RhinoScriptHandler handler, Obj xfaObject) {
        this.jsConstructor(handler, xfaObject);
    }

    public void jsConstructor(Object handler, Object xfaObject) {
        assert (xfaObject instanceof Obj);
        this.moXFAObject = (Obj)xfaObject;
        assert (handler instanceof RhinoScriptHandler);
        this.moHandler = (RhinoScriptHandler)handler;
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public Object get(String name, Scriptable start) {
        if (name.equals("Function")) {
            return super.get(name, start);
        }
        if (this.moScriptObj != null) {
            return this.moScriptObj.get(name, start);
        }
        try {
            ScriptFuncObj scriptFuncObj = this.moXFAObject.getScriptMethodInfo(name);
            if (scriptFuncObj != null && !this.moXFAObject.validateUsageFailedIsFatal(scriptFuncObj.getXFAVersion(), scriptFuncObj.getAvailability())) {
                return new FunctionObject(name, (Member)mInvokeMethod, (Scriptable)this);
            }
            DependencyTracker oDependencyTracker = this.moHandler.getAppModel().dependencyTracker();
            Arg oArg = new Arg();
            this.moXFAObject.getScriptProperty(oArg, name, oDependencyTracker, false, false);
            this.resolveArg(name, start, oArg);
            ScriptDebugger oDebugger = this.moHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.resolvedValue(name, oArg);
            }
            return this.moHandler.argToVariant(oArg);
        }
        catch (ExFull oEx) {
            this.moHandler.throwError(oEx);
            return Scriptable.NOT_FOUND;
        }
    }

    protected void resolveArg(String name, Scriptable start, Arg oArg) {
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.moScriptObj != null) {
            this.moScriptObj.put(name, start, value);
        } else {
            try {
                this.moXFAObject.setScriptProperty(name, this.moHandler.variantToArg(value), false);
            }
            catch (ExFull oEx) {
                this.moHandler.throwError(oEx);
            }
        }
    }

    public static Object invoke(Context cx, Scriptable obj, Object[] args, Function func) {
        LiveObject oThis = (LiveObject)obj;
        try {
            DependencyTracker oDependencyTracker = oThis.moHandler.getAppModel().dependencyTracker();
            Arg oRetVal = new Arg();
            String sFunctionName = ((FunctionObject)func).getFunctionName();
            Arg[] oArgs = new Arg[args.length];
            for (int i = 0; i < args.length; ++i) {
                oArgs[i] = oThis.moHandler.variantToArg(args[i]);
            }
            oThis.moXFAObject.invokeFunction(oRetVal, sFunctionName, oArgs, oDependencyTracker, false);
            ScriptDebugger oDebugger = oThis.moHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.resolvedValue(sFunctionName, oRetVal);
            }
            return oThis.moHandler.argToVariant(oRetVal);
        }
        catch (ExFull oEx) {
            oThis.moHandler.throwError(oEx);
            return Undefined.instance;
        }
    }

    void setScriptObject(ScriptObject oScriptObj) {
        this.moScriptObj = oScriptObj;
    }

    Obj getXFAObject() {
        return this.moXFAObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(((Object)((Object)this)).getClass().getSimpleName());
    }

    static {
        Method m;
        block2: {
            m = null;
            try {
                m = LiveObject.class.getMethod("invoke", Context.class, Scriptable.class, Object[].class, Function.class);
            }
            catch (NoSuchMethodException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        mInvokeMethod = m;
    }
}

