/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextMarker;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.markup.MarkupIn;
import com.adobe.xfa.text.markup.MarkupOut;
import com.adobe.xfa.ut.Rect;
import java.util.List;

public class TextRange {
    public static final int POSN_ANCHOR = 0;
    public static final int POSN_LOOSE = 1;
    public static final int POSN_START = 2;
    public static final int POSN_END = 3;
    private final TextPosn moAnchor;
    private final TextPosn moLoose;
    private TextPosn moStart;
    private TextPosn moEnd;

    public TextRange() {
        this.moAnchor = new TextPosn();
        this.moLoose = new TextPosn();
    }

    public TextRange(TextRange oSource) {
        this.moAnchor = new TextPosn(oSource.moAnchor);
        this.moLoose = new TextPosn(oSource.moLoose);
    }

    public TextRange(TextStream poStream) {
        this.moAnchor = new TextPosn(poStream);
        this.moLoose = new TextPosn(poStream, Integer.MAX_VALUE);
        this.reconcile();
    }

    public TextRange(TextStream poStream, int nNewAnchor, int nNewLoose) {
        this.moAnchor = new TextPosn(poStream, nNewAnchor);
        this.moLoose = new TextPosn(poStream, nNewLoose);
        this.reconcile();
    }

    public void associate(TextStream poStream) {
        this.moAnchor.associate(poStream, 0);
        this.moLoose.associate(poStream, Integer.MAX_VALUE);
        this.reconcile();
    }

    public void associate(TextStream poStream, int nNewAnchor, int nNewLoose) {
        this.moAnchor.associate(poStream, nNewAnchor);
        this.moLoose.associate(poStream, nNewLoose);
        this.reconcile();
    }

    public TextStream stream() {
        return this.moAnchor.stream();
    }

    public int count() {
        this.sortPositions();
        return this.moEnd.index() - this.moStart.index();
    }

    public int countText() {
        return this.countByType(2);
    }

    public int countField() {
        return this.countByType(3);
    }

    public int countEmbed() {
        return this.countByType(4);
    }

    public boolean isEmpty() {
        return this.moAnchor.index() == this.moLoose.index();
    }

    public TextPosn position(int ePosition) {
        switch (ePosition) {
            case 0: {
                return this.moAnchor;
            }
            case 1: {
                return this.moLoose;
            }
            case 2: {
                this.sortPositions();
                return this.moStart;
            }
            case 3: {
                this.sortPositions();
                return this.moEnd;
            }
        }
        return this.moAnchor;
    }

    public void position(int ePosition, int nNewPosition) {
        switch (ePosition) {
            case 0: {
                this.moAnchor.index(nNewPosition);
                break;
            }
            case 1: {
                this.moLoose.index(nNewPosition);
                break;
            }
            case 2: {
                this.sortPositions();
                this.moStart.index(nNewPosition);
                break;
            }
            case 3: {
                this.sortPositions();
                this.moEnd.index(nNewPosition);
            }
        }
        this.reconcile();
    }

    public void position(int ePosition, TextPosn oNewPosn) {
        switch (ePosition) {
            case 0: {
                this.moAnchor.copyData(oNewPosn);
                break;
            }
            case 1: {
                this.moLoose.copyData(oNewPosn);
                break;
            }
            case 2: {
                this.sortPositions();
                this.moStart.copyData(oNewPosn);
                break;
            }
            case 3: {
                this.sortPositions();
                this.moEnd.copyData(oNewPosn);
            }
        }
        this.reconcile();
    }

    public TextPosn anchor() {
        return this.position(0);
    }

    public void anchor(int nNewIndex) {
        this.position(0, nNewIndex);
    }

    public void anchor(TextPosn oNewPosn) {
        this.position(0, oNewPosn);
    }

    public TextPosn loose() {
        return this.position(1);
    }

    public void loose(int nNewIndex) {
        this.position(1, nNewIndex);
    }

    public void loose(TextPosn oNewPosn) {
        this.position(1, oNewPosn);
    }

    public TextPosn start() {
        return this.position(2);
    }

    public void start(int nNewIndex) {
        this.position(2, nNewIndex);
    }

    public void start(TextPosn oNewPosn) {
        this.position(2, oNewPosn);
    }

    public TextPosn end() {
        return this.position(3);
    }

    public void end(int nNewIndex) {
        this.position(3, nNewIndex);
    }

    public void end(TextPosn oNewPosn) {
        this.position(3, oNewPosn);
    }

    public boolean union(TextRange oAdd, TextRange oResult) {
        boolean bOverlap;
        if (this.stream() != oAdd.stream() || this.stream() == null) {
            return false;
        }
        int nStart = this.start().index();
        int nEnd = this.end().index();
        int nAddStart = oAdd.start().index();
        int nAddEnd = oAdd.end().index();
        if (nStart < nAddStart) {
            bOverlap = nEnd >= nAddStart;
        } else {
            bOverlap = nAddEnd >= nStart;
            nStart = nAddStart;
        }
        if (nEnd < nAddEnd) {
            nEnd = nAddEnd;
        }
        oResult.associate(this.stream(), nStart, nEnd);
        return bOverlap;
    }

    public String text(boolean bIncludeFields) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return "";
        }
        this.sortPositions();
        return poStream.rangeText(this.moStart, this.moEnd, bIncludeFields);
    }

    public String text() {
        return this.text(false);
    }

    public void text(TextStream oText) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return;
        }
        this.sortPositions();
        poStream.rangeText(this.moStart, this.moEnd, oText);
    }

    public void enumerateMarkers(List<TextMarker> oMarkers, boolean bPositionMarkers, boolean bRangeMarkers, boolean bSubsetOnly) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return;
        }
        this.sortPositions();
        poStream.rangeEnumMarker(this.moStart, this.moEnd, oMarkers, bPositionMarkers, bRangeMarkers, bSubsetOnly);
    }

    public void enumerateMarkers(List<TextMarker> oMarkers) {
        this.enumerateMarkers(oMarkers, false, true, false);
    }

    public void delete(boolean bRaw) {
        if (this.stream() == null || this.isEmpty()) {
            return;
        }
        this.sortPositions();
        this.moStart.deleteAhead(this.moEnd.index() - this.moStart.index(), bRaw);
    }

    public void delete() {
        this.delete(false);
    }

    public void replace(char cReplace, boolean bRaw) {
        if (this.stream() == null) {
            return;
        }
        String sReplace = "";
        sReplace = sReplace + cReplace;
        this.replace(sReplace, bRaw);
    }

    public void replace(char cReplace) {
        this.replace(cReplace, false);
    }

    public void replace(String sReplace, boolean bRaw) {
        if (this.stream() == null) {
            return;
        }
        this.sortPositions();
        this.stream().rangeReplace((TextPosnBase)this.moStart, this.moEnd.index() - this.moStart.index(), sReplace, bRaw);
    }

    public final void replace(String sReplace) {
        this.replace(sReplace, false);
    }

    public void replace(TextStream oReplace, boolean bRaw) {
        if (this.stream() == null) {
            return;
        }
        this.sortPositions();
        this.stream().rangeReplace((TextPosnBase)this.moStart, this.moEnd.index() - this.moStart.index(), oReplace, bRaw);
    }

    public final void replace(TextStream oReplace) {
        this.replace(oReplace, false);
    }

    public TextMarker insert(TextMarker poMarker) {
        if (this.stream() == null) {
            return null;
        }
        this.sortPositions();
        return this.stream().rangeMarker(this.moStart, this.moEnd, poMarker);
    }

    public TextAttr attribute() {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return TextAttr.defaultAttr(false);
        }
        this.sortPositions();
        return poStream.rangeGetAttr(this.moStart, this.moEnd);
    }

    public void attribute(TextAttr oNewAttr, boolean bRaw) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return;
        }
        this.sortPositions();
        poStream.rangeSetAttr(this.moStart, this.moEnd, oNewAttr, bRaw);
    }

    public final void attribute(TextAttr oNewAttr) {
        this.attribute(oNewAttr, false);
    }

    public void markup(MarkupOut oMarkup, TextAttr poInitAttr, boolean bDefaultInitAttr, boolean bFlattenFields) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return;
        }
        this.sortPositions();
        poStream.rangeMarkup(this.moStart, this.moEnd, oMarkup, poInitAttr, bDefaultInitAttr, bFlattenFields);
    }

    public void markup(MarkupIn oMarkup) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return;
        }
        this.delete();
        poStream.rangeMarkup(this.end(), oMarkup);
    }

    public boolean grabWord(int eWordMode) {
        this.sortPositions();
        this.moStart.wordStart(eWordMode);
        this.moEnd.nextWord(false, eWordMode);
        this.tighten();
        this.reconcile();
        return this.moStart.index() != this.moEnd.index();
    }

    public boolean grabWord() {
        return this.grabWord(0);
    }

    public boolean grabLine() {
        this.sortPositions();
        if (!this.moStart.start()) {
            return false;
        }
        this.moEnd.nextLine();
        this.reconcile();
        return true;
    }

    public boolean grabPara() {
        TextPosnBase oTemp;
        this.tighten();
        boolean bEmpty = this.isEmpty();
        this.sortPositions();
        this.moStart.paraStart();
        boolean bSuppressEnd = false;
        if (!bEmpty && (oTemp = new TextPosnBase(this.moEnd)).prevUserPosnType(false) == 5) {
            bSuppressEnd = true;
        }
        if (!bSuppressEnd) {
            this.moEnd.nextPara();
        }
        this.reconcile();
        return true;
    }

    public void tighten() {
        this.sortPositions();
        if (this.moStart.index() == this.moEnd.index()) {
            int ePrev = this.moStart.prev(3, true);
            int eNext = this.moStart.next(3, true);
            if (ePrev != 1 || eNext != 1 && eNext != 0) {
                this.moStart.tighten(false);
                if (this.moStart.isAtStart()) {
                    this.moStart.tighten(true);
                    this.moEnd.tighten(true);
                } else {
                    this.moEnd.tighten(false);
                }
            }
        } else {
            this.moStart.tighten(true);
            if (this.moEnd.next(3, true) != 0) {
                this.moEnd.tighten(false);
            }
            if (this.moStart.index() > this.moEnd.index()) {
                if (this.moEnd.isAtStart()) {
                    this.moEnd.tighten(true);
                } else {
                    this.moStart.tighten(false);
                }
            }
        }
    }

    public TextPosnBase charPosition(int lIndex) {
        return this.start().charPosition(lIndex);
    }

    public TextRange charRange(int lStart, int lLength) {
        return this.start().charRange(lStart, lLength);
    }

    public boolean getSelectionRectangles(List<Rect> oRectangles) {
        TextStream poStream = this.stream();
        if (poStream == null) {
            return false;
        }
        TextDisplay poDisplay = poStream.display();
        if (poDisplay == null) {
            return false;
        }
        return false;
    }

    public void copyFrom(TextRange oSource) {
        this.moAnchor.copyFrom(oSource.moAnchor);
        this.moLoose.copyFrom(oSource.moLoose);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextRange test = (TextRange)object;
        return this.moAnchor.equals(test.moAnchor) && this.moLoose.equals(test.moLoose);
    }

    public int hashCode() {
        int hash = 59;
        hash = hash * 31 ^ this.moAnchor.hashCode();
        hash = hash * 31 ^ this.moLoose.hashCode();
        return hash;
    }

    public boolean notEqual(TextRange oCompare) {
        return !this.equals(oCompare);
    }

    private int countByType(int eType) {
        this.sortPositions();
        TextPosn oCurrent = new TextPosn(this.moStart);
        int nCount = 0;
        int eCurrent = oCurrent.next();
        while (oCurrent.index() <= this.moEnd.index() && eCurrent != 0) {
            if (eCurrent == eType) {
                ++nCount;
            }
            eCurrent = oCurrent.next();
        }
        return nCount;
    }

    private void reconcile() {
        this.tighten();
        this.sortPositions();
        this.moStart.position(1);
        this.moEnd.position(0);
    }

    private final void sortPositions() {
        if (this.moAnchor.index() <= this.moLoose.index()) {
            this.moStart = this.moAnchor;
            this.moEnd = this.moLoose;
        } else {
            this.moStart = this.moLoose;
            this.moEnd = this.moAnchor;
        }
    }
}

