/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.text.TextTabList;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupOut;
import com.adobe.xfa.ut.UnitSpan;

public class MarkupEngineOut
extends MarkupOut {
    private MarkupAttr mpMarkupAttr;
    private final StringBuilder mpTranslation = new StringBuilder();
    private int miNestedDepth = 0;
    private final TextAttr moAttrState = new TextAttr();

    public String translation() {
        if (this.mpTranslation.length() > 0) {
            while (this.miNestedDepth > 0) {
                this.closeScopedBlock();
            }
        }
        return this.mpTranslation.toString();
    }

    @Override
    public void reset() {
        this.moAttrState.setDefault(true);
        this.moAttrState.typefaceEnable(false);
        this.moAttrState.sizeEnable(false);
        this.mpTranslation.delete(0, this.mpTranslation.length());
        this.miNestedDepth = 0;
        this.flushJustification();
        this.flushSpacing();
        this.flushIndentation();
    }

    @Override
    public void text(String sStrText) {
        this.mpTranslation.append(this.flushJustification());
        this.mpTranslation.append(this.flushSpacing());
        this.mpTranslation.append(this.flushIndentation());
        StringBuilder oStrTextNew = new StringBuilder(sStrText);
        String sUc = "\\uc";
        int lBytes = 1;
        for (int i = 0; i < oStrTextNew.length(); ++i) {
            int count;
            char c = oStrTextNew.charAt(i);
            if (c == '\\' || this.mpMarkupAttr.hasBlockScoping() && (c == this.mpMarkupAttr.blockPrefix() || c == this.mpMarkupAttr.blockSuffix())) {
                oStrTextNew.insert(i, "\\");
                ++i;
                continue;
            }
            if (c == '\t') {
                String sReplace = this.mpMarkupAttr.lookup(136);
                oStrTextNew.replace(i, i + 1, sReplace);
                if (sReplace.length() <= 0) continue;
                i += sReplace.length() - 1;
                continue;
            }
            if (c == '\n') {
                String sReplace = this.mpMarkupAttr.lookup(37);
                oStrTextNew.replace(i, i + 1, sReplace);
                if (sReplace.length() <= 0) continue;
                i += sReplace.length() - 1;
                continue;
            }
            if (c < '\u001f') {
                String sReplacement = this.convertSpecialChar(c);
                oStrTextNew.replace(i, i + 1, sReplacement);
                if (sReplacement.length() <= 0) continue;
                i += sReplacement.length() - 1;
                continue;
            }
            if (c <= '~') continue;
            char u = oStrTextNew.charAt(i);
            StringBuilder sReplacement = new StringBuilder();
            String sUnicode = "\\u";
            sUnicode = sUnicode + Integer.toString(u);
            StringBuilder sHex = new StringBuilder(this.convertSpecialChar(u));
            for (count = 4; sHex.length() > count; count += 4) {
                String sInsert = "\\'";
                if (sHex.length() < count + 2) {
                    sInsert = sInsert + "0";
                }
                sHex.replace(count, count, sInsert);
            }
            if ((count /= 4) != lBytes) {
                sReplacement.append(sUc);
                sReplacement.append(Integer.toString(count));
            }
            sReplacement.append(sUnicode);
            sReplacement.append((CharSequence)sHex);
            oStrTextNew.replace(i, i + 1, sReplacement.toString());
            if (sReplacement.length() <= 0) continue;
            i += sReplacement.length() - 1;
        }
        if (this.blockText()) {
            this.mpTranslation.append("{");
        }
        this.mpTranslation.append((CharSequence)oStrTextNew);
        if (this.blockText()) {
            this.mpTranslation.append("}");
        }
    }

    @Override
    public void attr(TextAttr oAttr) {
        TextAttr oChangedAttrs = new TextAttr(oAttr);
        oChangedAttrs.dropSame(this.moAttrState, false);
        String sIndentation = "";
        String sJustification = "";
        String sSpacing = "";
        String sTabs = "";
        if (this.mpMarkupAttr.hasParagraphAttr()) {
            sIndentation = this.outputIndentation(oChangedAttrs);
            sJustification = this.outputJustification(oChangedAttrs);
            sSpacing = this.outputSpacing(oChangedAttrs);
            sTabs = this.outputTabs(oChangedAttrs);
        }
        String sFont = this.outputFont(oChangedAttrs);
        String sEffects = this.outputEffects(oChangedAttrs);
        this.mpTranslation.append(sIndentation);
        this.mpTranslation.append(sJustification);
        this.mpTranslation.append(sSpacing);
        this.mpTranslation.append(sTabs);
        this.mpTranslation.append(sFont);
        this.mpTranslation.append(sEffects);
        this.moAttrState.override(oAttr);
        if (!oAttr.typefaceEnable()) {
            this.moAttrState.typefaceEnable(false);
        }
    }

    @Override
    public void para() {
        this.mpTranslation.append(this.flushJustification());
        this.mpTranslation.append(this.mpMarkupAttr.lookup(19));
        this.mpTranslation.append(this.flushSpacing());
        this.mpTranslation.append(this.flushIndentation());
    }

    protected MarkupEngineOut(MarkupAttr pMarkupAttr) {
        this.mpMarkupAttr = pMarkupAttr;
        this.reset();
    }

    protected MarkupAttr markupAttr() {
        return this.mpMarkupAttr;
    }

    protected StringBuilder translationText() {
        return this.mpTranslation;
    }

    protected String outputEffects(TextAttr oAttr) {
        StringBuilder sOut = new StringBuilder();
        sOut.append(this.outputUnderline(oAttr));
        if (oAttr.weightEnable()) {
            sOut.append(this.mpMarkupAttr.lookup(oAttr.weight() >= 700 ? 77 : 78));
        }
        if (oAttr.italicEnable()) {
            sOut.append(this.mpMarkupAttr.lookup(oAttr.italic() ? 79 : 80));
        }
        if (oAttr.strikeoutEnable()) {
            sOut.append(this.mpMarkupAttr.lookup(oAttr.strikeout() == 18 ? 81 : 83));
        }
        if (oAttr.baselineShiftEnable()) {
            UnitSpan oShift = oAttr.baselineShift().applyShift(UnitSpan.ZERO, oAttr.size());
            oShift = oShift.abs();
            if (oAttr.baselineShift().isDownShift()) {
                sOut.append(this.outputPointSize(117, oShift, true, this.markupAttr().pointSizeFactor()));
            } else {
                sOut.append(this.outputPointSize(118, oShift, true, this.markupAttr().pointSizeFactor()));
            }
        }
        if (oAttr.colourEnable()) {
            sOut.append(this.outputColour(oAttr.colour()));
        }
        return sOut.toString();
    }

    protected String outputFont(TextAttr oAttr) {
        StringBuilder sOut = new StringBuilder();
        if (oAttr.typefaceEnable()) {
            sOut.append(this.outputFontFaceName(oAttr));
        }
        sOut.append(this.outputPointSize(66, oAttr.size(), oAttr.sizeEnable(), this.markupAttr().pointSizeFactor()));
        return sOut.toString();
    }

    protected String outputFontFaceName(TextAttr oAttr) {
        if (oAttr.typefaceEnable()) {
            return oAttr.typeface();
        }
        return TextAttr.defaultFull.typeface();
    }

    protected String outputColour(GFXColour oColour) {
        return "";
    }

    protected String outputIndentation(TextAttr oAttr) {
        StringBuilder sOut = new StringBuilder();
        UnitSpan oSpecial = oAttr.flattenMeasurement(oAttr.special());
        sOut.append(this.outputPointSize(57, oSpecial, oAttr.specialEnable()));
        if (oAttr.specialEnable() && oSpecial.value() < 0) {
            UnitSpan oMarginL = oAttr.marginLEnable() ? oAttr.flattenMeasurement(oAttr.marginL()) : UnitSpan.ZERO;
            oMarginL = oMarginL.subtract(oSpecial);
            sOut.append(this.outputPointSize(58, oMarginL));
        } else {
            sOut.append(this.outputPointSize(oAttr, 58, oAttr.marginL(), oAttr.marginLEnable()));
        }
        sOut.append(this.outputPointSize(oAttr, 59, oAttr.marginR(), oAttr.marginREnable()));
        sOut.append(this.outputPointSize(oAttr, 61, oAttr.spaceBefore(), oAttr.spaceBeforeEnable()));
        sOut.append(this.outputPointSize(oAttr, 62, oAttr.spaceAfter(), oAttr.spaceAfterEnable()));
        return sOut.toString();
    }

    protected String outputJustification(TextAttr oAttr) {
        StringBuilder sOut = new StringBuilder();
        if (oAttr.justifyHEnable()) {
            switch (oAttr.justifyH()) {
                case 5: {
                    sOut.append(this.mpMarkupAttr.lookup(122));
                    break;
                }
                case 6: {
                    sOut.append(this.mpMarkupAttr.lookup(123));
                    break;
                }
                case 7: {
                    sOut.append(this.mpMarkupAttr.lookup(124));
                    break;
                }
                case 8: {
                    sOut.append(this.mpMarkupAttr.lookup(120));
                    break;
                }
                case 9: {
                    sOut.append(this.mpMarkupAttr.lookup(121));
                    break;
                }
            }
        }
        if (oAttr.justifyVEnable()) {
            switch (oAttr.justifyV()) {
                case 1: {
                    sOut.append(this.mpMarkupAttr.lookup(133));
                    break;
                }
                case 2: {
                    sOut.append(this.mpMarkupAttr.lookup(134));
                    break;
                }
                case 3: {
                    sOut.append(this.mpMarkupAttr.lookup(135));
                    break;
                }
            }
        }
        return sOut.toString();
    }

    protected String outputTabs(TextAttr oAttr) {
        StringBuilder sOut = new StringBuilder();
        if (oAttr.tabsEnable()) {
            TextTabList oTabList = oAttr.tabs();
            sOut.append(this.outputPointSize(137, oTabList.uniform().tabStop()));
            for (int i = 1; i <= oTabList.size(); ++i) {
                TextTab oTab = oTabList.tabAt(i);
                switch (oTab.tabType()) {
                    case 1: {
                        sOut.append(this.mpMarkupAttr.lookup(140));
                        break;
                    }
                    case 2: 
                    case 5: {
                        sOut.append(this.mpMarkupAttr.lookup(141));
                        break;
                    }
                    case 3: {
                        sOut.append(this.mpMarkupAttr.lookup(142));
                        break;
                    }
                    default: {
                        sOut.append(this.mpMarkupAttr.lookup(139));
                    }
                }
                sOut.append(this.outputPointSize(138, oTab.tabStop()));
            }
        }
        return sOut.toString();
    }

    protected String outputUnderline(TextAttr oAttr) {
        if (oAttr.underlineEnable()) {
            int eMarkup;
            switch (oAttr.underline()) {
                case 19: {
                    eMarkup = 87;
                    break;
                }
                case 18: {
                    eMarkup = 85;
                    break;
                }
                case 34: {
                    eMarkup = 86;
                    break;
                }
                case 35: {
                    eMarkup = 88;
                    break;
                }
                default: {
                    eMarkup = 90;
                }
            }
            return this.mpMarkupAttr.lookup(eMarkup);
        }
        return "";
    }

    protected String outputSpacing(TextAttr oAttr) {
        return "";
    }

    protected boolean isSpecialChar(char c) {
        return false;
    }

    protected String convertSpecialChar(char c) {
        String s = "";
        return s + c;
    }

    protected String flushJustification() {
        return "";
    }

    protected String flushIndentation() {
        return "";
    }

    protected String flushSpacing() {
        return "";
    }

    protected boolean blockText() {
        return true;
    }

    protected void setMarkupAttr(MarkupAttr pMarkupAttr) {
        this.mpMarkupAttr = pMarkupAttr;
    }

    @Override
    public void openScopedBlock() {
        if (this.mpMarkupAttr.hasBlockScoping()) {
            this.mpTranslation.append(this.mpMarkupAttr.blockPrefix());
            ++this.miNestedDepth;
        }
    }

    @Override
    public void closeScopedBlock() {
        if (this.mpMarkupAttr.hasBlockScoping()) {
            this.mpTranslation.append(this.mpMarkupAttr.blockSuffix());
            --this.miNestedDepth;
        }
    }

    protected void resetFont() {
        this.moAttrState.typefaceEnable(false);
        this.moAttrState.sizeEnable(false);
    }

    protected String outputPointSize(TextAttr oAttr, int eTag, TextMeasurement oValue, boolean bEnable, int lUnitsPerPoint) {
        return this.outputPointSize(eTag, oAttr.flattenMeasurement(oValue), bEnable, lUnitsPerPoint);
    }

    protected String outputPointSize(TextAttr oAttr, int eTag, TextMeasurement oValue, boolean bEnable) {
        return this.outputPointSize(eTag, oAttr.flattenMeasurement(oValue), bEnable, 20);
    }

    protected String outputPointSize(int eTag, UnitSpan oValue, boolean bEnable, int lUnitsPerPoint) {
        StringBuilder sOut = new StringBuilder();
        if (bEnable) {
            UnitSpan oCvt = new UnitSpan(19, oValue.units(), oValue.value());
            sOut.append(this.mpMarkupAttr.lookup(eTag));
            sOut.append(Float.toString(Math.round((float)(oCvt.value() * lUnitsPerPoint) / 1000.0f)));
            sOut.append(this.mpMarkupAttr.delimiter());
        }
        return sOut.toString();
    }

    protected String outputPointSize(int eTag, UnitSpan oValue, boolean bEnable) {
        return this.outputPointSize(eTag, oValue, bEnable, 20);
    }

    protected String outputPointSize(int eTag, UnitSpan oValue) {
        return this.outputPointSize(eTag, oValue, true);
    }

    protected TextAttr previousState() {
        return this.moAttrState;
    }
}

