/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.DiffService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionIterator;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffInfo {
    public static final FastDateFormat DATE_DEFAULT = FastDateFormat.getInstance("dd.MM.yyyy HH:mm:ss");
    private static final Logger log = LoggerFactory.getLogger(DiffInfo.class);
    private final Resource content;
    private final TYPE type;

    public DiffInfo(Resource c, TYPE l) {
        this.content = c;
        this.type = l;
    }

    public Resource getContent() {
        return this.content;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getDiffOutput(DiffService service, String current, String oldText, boolean isRichText) {
        if (service != null) {
            if (this.getType() == TYPE.ADDED) {
                return service.diff(current, null, isRichText);
            }
            if (this.getType() == TYPE.REMOVED) {
                return service.diff(null, oldText, isRichText);
            }
            return service.diff(current, oldText, isRichText);
        }
        return null;
    }

    public static Resource getVersionedResource(Resource res, String versionLabel) {
        Node currentNode = res.adaptTo(Node.class);
        if (currentNode == null) {
            return null;
        }
        try {
            Node versionNode = DiffInfo.getVersionedNode(currentNode, versionLabel);
            if (versionNode != null) {
                return res.getResourceResolver().getResource(versionNode.getPath());
            }
        }
        catch (RepositoryException e) {
            log.error("Error while trying to get versioned node for path " + res.getPath() + ", version " + versionLabel, e);
        }
        return null;
    }

    private static Node getVersionedNode(Node node, String versionTag) throws RepositoryException {
        String path = node.getPath();
        while (node != null && !node.isNodeType("mix:versionable")) {
            if (node.getDepth() > 0) {
                node = node.getParent();
                continue;
            }
            node = null;
        }
        if (node == null) {
            log.debug("getVersionedNode: No versionable node exists at path '{}'", (Object)path);
            return null;
        }
        Version versionNode = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_DEFAULT.getPattern());
            Date d = sdf.parse(versionTag);
            Calendar versionDate = Calendar.getInstance();
            versionDate.setTime(d);
            versionNode = DiffInfo.getVersion(node, versionDate);
        }
        catch (ParseException sdf) {
            // empty catch block
        }
        if (versionNode == null) {
            try {
                versionNode = node.getVersionHistory().getVersion(versionTag);
            }
            catch (VersionException ve) {
                try {
                    versionNode = node.getVersionHistory().getVersionByLabel(versionTag);
                }
                catch (VersionException d) {
                    // empty catch block
                }
            }
        }
        if (versionNode == null) {
            log.debug("getVersionedNode: Version '{}' not found for path '{}'", (Object)versionTag, (Object)path);
            return null;
        }
        if (!node.getPath().equals(path)) {
            String childPath;
            Session session = node.getSession();
            if (!session.itemExists(childPath = versionNode.getPath() + "/" + "jcr:frozenNode" + path.substring(node.getPath().length()))) {
                log.debug("getVersionedNode: Version '{}' not found for path '{}'", (Object)versionTag, (Object)path);
                return null;
            }
            versionNode = (Node)session.getItem(childPath);
        } else if (versionNode.hasNode("jcr:frozenNode")) {
            versionNode = versionNode.getNode("jcr:frozenNode");
        } else {
            log.debug("getVersionedNode: Frozen node not found in version '{}' for path '{}'", (Object)versionTag, (Object)path);
            return null;
        }
        return versionNode;
    }

    private static Node getVersion(Node versionedNode, Calendar cal) throws RepositoryException {
        ArrayList<Version> revisions = new ArrayList<Version>();
        VersionIterator iter = versionedNode.getVersionHistory().getAllVersions();
        while (iter.hasNext()) {
            revisions.add(iter.nextVersion());
        }
        Collections.sort(revisions, new Comparator<Version>(){

            @Override
            public int compare(Version r1, Version r2) {
                try {
                    return r2.getCreated().compareTo(r1.getCreated());
                }
                catch (RepositoryException re) {
                    return 0;
                }
            }
        });
        for (Version v : revisions) {
            if (v.getCreated().compareTo(cal) > 0) continue;
            return v;
        }
        return null;
    }

    public static enum TYPE {
        ADDED,
        REMOVED,
        MOVED,
        SAME;

    }
}

