/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.predicate.PredicateProvider;
import com.day.cq.commons.predicate.ResourceFilter;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractPredicateServlet
extends SlingAllMethodsServlet {
    public static final String PATH_PARAM = "path";
    public static final String PREDICATE_PARAM = "predicate";
    public static final String FILTER_PARAM = "filter";
    private static final long serialVersionUID = 6457830085969491553L;
    private final Logger log = LoggerFactory.getLogger(AbstractPredicateServlet.class);
    @Reference
    private PredicateProvider provider;

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response, this.getPredicate(request));
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    protected int selectorPredicateStart() {
        return Integer.MAX_VALUE;
    }

    public Predicate getPredicate(SlingHttpServletRequest request) {
        Predicate predicate = TruePredicate.INSTANCE;
        if (this.provider == null) {
            this.log.warn("Predicate provider not bound.");
        } else {
            HashSet<Predicate> predicates = new HashSet<Predicate>();
            String[] selectors = request.getRequestPathInfo().getSelectors();
            for (int i = this.selectorPredicateStart(); i < selectors.length; ++i) {
                Predicate p = this.provider.getPredicate(selectors[i]);
                if (p == null) {
                    this.log.warn("Unable to retrieve predicate " + selectors[i]);
                    continue;
                }
                predicates.add(p);
            }
            if (request.getParameterMap().containsKey(PREDICATE_PARAM)) {
                for (String pred : request.getParameterValues(PREDICATE_PARAM)) {
                    Predicate p = this.provider.getPredicate(pred);
                    if (p == null) {
                        this.log.warn("Unable to retrieve predicate " + pred);
                        continue;
                    }
                    predicates.add(p);
                }
            }
            if (request.getParameterMap().containsKey(FILTER_PARAM)) {
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                for (String filter : request.getParameterValues(FILTER_PARAM)) {
                    try {
                        predicates.add(new ResourceFilter(loader.loadClass(filter)));
                    }
                    catch (ClassNotFoundException e) {
                        this.log.warn("Requested filter class {} not found.", (Object)filter);
                    }
                }
            }
            if (!predicates.isEmpty()) {
                predicate = AnyPredicate.getInstance(predicates);
            }
        }
        return predicate;
    }

    protected void bindProvider(PredicateProvider predicateProvider) {
        this.provider = predicateProvider;
    }

    protected void unbindProvider(PredicateProvider predicateProvider) {
        if (this.provider == predicateProvider) {
            this.provider = null;
        }
    }
}

