/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.servlets.NonExistingResourceServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.OptingServlet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/apps/sling/nonexisting/GET.servlet", "/apps/sling/nonexisting/POST.servlet", "/apps/sling/nonexisting/PUT.servlet"})
@Reference(name="Servlet", referenceInterface=NonExistingResourceServlet.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
public class NonExistingDispatcherServlet
extends GenericServlet
implements OptingServlet {
    private final Logger log = LoggerFactory.getLogger(NonExistingDispatcherServlet.class);
    private ComponentContext context;
    private List<ServiceReference> unhandledServlets = new ArrayList<ServiceReference>();
    private SortedMap<ServiceReference, NonExistingResourceServlet> servlets = new TreeMap<ServiceReference, NonExistingResourceServlet>(new Comparator<ServiceReference>(){

        @Override
        public int compare(ServiceReference ref1, ServiceReference ref2) {
            int rank2;
            long id2;
            long id1 = NonExistingDispatcherServlet.this.getServiceID(ref1);
            if (id1 == (id2 = NonExistingDispatcherServlet.this.getServiceID(ref2))) {
                return 0;
            }
            int rank1 = NonExistingDispatcherServlet.this.getServiceRanking(ref1);
            if (rank1 == (rank2 = NonExistingDispatcherServlet.this.getServiceRanking(ref2))) {
                return (int)(id1 - id2);
            }
            return rank2 - rank1;
        }
    });
    private static final String SERVLET_REQUEST_ATTR = NonExistingResourceServlet.class.getName();

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        NonExistingResourceServlet servlet = this.findServlet(request);
        if (servlet != null) {
            request.setAttribute(SERVLET_REQUEST_ATTR, servlet);
            request.getRequestProgressTracker().log("{0}: will dispatch to {1}", this.getClass().getSimpleName(), servlet.getClass().getName());
            return true;
        }
        request.getRequestProgressTracker().log("{0}: no servlet found");
        return false;
    }

    public void service(ServletRequest request, ServletResponse res) throws ServletException, IOException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        NonExistingResourceServlet servlet = (NonExistingResourceServlet)request.getAttribute(SERVLET_REQUEST_ATTR);
        if (servlet != null) {
            slingRequest.getRequestProgressTracker().startTimer(servlet.getClass().getName());
            servlet.service(request, res);
            slingRequest.getRequestProgressTracker().logTimer(servlet.getClass().getName());
        } else {
            servlet = this.findServlet(slingRequest);
            if (servlet != null) {
                slingRequest.getRequestProgressTracker().log("{0}: will dispatch to {1}", this.getClass().getSimpleName(), servlet.getClass().getName());
                slingRequest.getRequestProgressTracker().startTimer(servlet.getClass().getName());
                servlet.service(request, res);
                slingRequest.getRequestProgressTracker().logTimer(servlet.getClass().getName());
            } else {
                slingRequest.getRequestProgressTracker().log("{0}: no servlet found");
                SlingHttpServletResponse response = (SlingHttpServletResponse)res;
                response.sendError(500, "No " + NonExistingResourceServlet.class.getName() + " found for handling sling:nonexisting case (and no OptingServlet support)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NonExistingResourceServlet findServlet(SlingHttpServletRequest request) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            for (NonExistingResourceServlet servlet : this.servlets.values()) {
                if (!servlet.accepts(request)) continue;
                return servlet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            this.context = context;
            for (ServiceReference reference : this.unhandledServlets) {
                this.registerServlet(reference);
            }
            this.unhandledServlets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindServlet(ServiceReference reference) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            if (this.context == null) {
                this.unhandledServlets.add(reference);
            } else {
                this.registerServlet(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindServlet(ServiceReference reference) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            this.unregisterServlet(reference);
            this.unhandledServlets.remove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServlet(ServiceReference reference) {
        NonExistingResourceServlet servlet = (NonExistingResourceServlet)this.context.locateService("Servlet", reference);
        if (servlet != null) {
            SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
            synchronized (sortedMap) {
                this.servlets.put(reference, servlet);
                this.log.info("Servlets in order: " + this.servlets.values().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServlet(ServiceReference reference) {
        SortedMap<ServiceReference, NonExistingResourceServlet> sortedMap = this.servlets;
        synchronized (sortedMap) {
            this.servlets.remove(reference);
        }
    }

    private long getServiceID(ServiceReference reference) {
        return (Long)reference.getProperty("service.id");
    }

    private int getServiceRanking(ServiceReference reference) {
        Object obj = reference.getProperty("service.ranking");
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        this.log.warn("Component " + reference.getProperty("component.name") + " has a non-Integer '" + "service.ranking" + "' property");
        return 0;
    }
}

