/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.handler;

import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class HashableContentUpdateHandler
implements ContentUpdateHandler {
    private static final String NT_CONTENT_SYNC_HASH = "cq:ContentSyncHash";
    public static final String HASH_PROPERTY = "md5";

    @Deprecated
    protected String getHash(RequestResponseFactory factory, HttpServletResponse response) throws RepositoryException {
        throw new UnsupportedOperationException("getHash is no longer supported");
    }

    @Deprecated
    protected String getHash(byte[] bytes) throws RepositoryException {
        throw new UnsupportedOperationException("getHash is no longer supported");
    }

    protected boolean hashMatches(Session session, String cachePath, String hash) throws RepositoryException {
        String hashPath = cachePath + "/" + "jcr:content" + "/" + HASH_PROPERTY;
        return session.propertyExists(hashPath) && session.getProperty(hashPath).getString().equals(hash);
    }

    protected void writeHash(Node node, String hash) throws RepositoryException {
        node.addMixin(NT_CONTENT_SYNC_HASH);
        node.setProperty(HASH_PROPERTY, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream writeHashAndGetStream(InputStream in, Node node) throws IOException, RepositoryException {
        File tempDir = Files.createTempDir();
        File tempFile = new File(tempDir, "stream");
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                ByteStreams.copy(in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
            }
            ByteSource byteSource = Files.asByteSource(tempFile);
            HashCode hashCode = this.getHashCode(byteSource);
            this.writeHash(node, hashCode.toString());
            InputStream inputStream = byteSource.openStream();
            return inputStream;
        }
        finally {
            FileUtils.deleteDirectory(tempDir);
        }
    }

    protected HashCode getHashCode(ByteSource byteSource) throws IOException {
        return ByteStreams.hash(byteSource, Hashing.sha256());
    }
}

