/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMetaFactory;
import com.day.cq.dam.api.Context;
import com.day.cq.dam.api.Processor;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.commons.handler.Filter;
import com.day.cq.dam.commons.handler.FilterStateListener;
import com.day.cq.dam.commons.handler.SimpleContext;
import com.day.cq.dam.commons.handler.XPacketFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class XMPProcessor
implements Processor,
FilterStateListener {
    private Context context;
    private XPacketFilter topFilter;

    public XMPProcessor(Context context) {
        this.context = context;
        this.topFilter = new XPacketFilter();
        this.topFilter.setFilterStateListener(this);
        this.topFilter.setAutoReset(true);
    }

    @Override
    public final void process(byte[] buf, int off, int len) throws IOException {
        this.topFilter.filter(buf, off, len);
    }

    @Override
    public OutputStream started(Filter filter) {
        return new ByteArrayOutputStream(8192);
    }

    @Override
    public void ended(Filter filter, OutputStream out) {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)out;
        try {
            byte[] buf = bos.toByteArray();
            XMPMetaFactory.parse(new ByteArrayInputStream(buf));
            this.context.addMetadata(new ByteArrayInputStream(buf));
        }
        catch (XMPException e) {
            String msg = "Unable to get XMP object from input";
            this.context.addException(new ProcessorException(msg, e, this));
        }
    }

    public static InputStream process(InputStream in) throws IOException, ProcessorException {
        int len;
        SimpleContext context = new SimpleContext();
        XMPProcessor processor = new XMPProcessor(context);
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            processor.process(buf, 0, len);
        }
        InputStream[] metadata = context.getMetadata();
        if (metadata != null && metadata.length > 0) {
            return metadata[0];
        }
        ProcessorException[] exceptions = context.getExceptions();
        if (exceptions != null) {
            throw exceptions[exceptions.length - 1];
        }
        return null;
    }
}

