/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.thumbnail.provider;

import com.day.cq.commons.thumbnail.ThumbnailProvider;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Component(metatype=false)
@Service
@Property(name="thumbnail.provider.name", value={"dam:Asset"})
public class AssetThumbnailProvider
implements ThumbnailProvider {
    private static String DEFAULT_ASSET_ICON = "/libs/cq/ui/widgets/themes/default/icons/240x180/page.png";

    @Override
    public String getThumbnailPath(Resource resource, int width, int height, Map<String, Object> additionalConf) {
        String damThumbnailName;
        Asset asset = resource.adaptTo(Asset.class);
        Rendition rendition = asset.getRendition(damThumbnailName = this.getName(width, height, additionalConf));
        rendition = rendition == null ? asset.getRendition("dam:thumbnail_" + width + ".png") : rendition;
        Rendition rendition2 = rendition = rendition == null ? UIHelper.getBestfitRendition(asset, width) : rendition;
        if (rendition == null || "original".equals(rendition.getName())) {
            return DEFAULT_ASSET_ICON;
        }
        return rendition.getPath();
    }

    private String getName(int width, int height, Map<String, Object> additionalConf) {
        String[] stringArray;
        boolean doCenter = false;
        if (additionalConf.containsKey("doCenter")) {
            doCenter = (Boolean)additionalConf.get("doCenter");
        }
        if (doCenter) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "margin";
        } else {
            stringArray = null;
        }
        String[] selectors = stringArray;
        return DamUtil.getThumbnailName(width, height, selectors);
    }
}

