/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;

public final class PrivateFolderAndCollectionUtil {
    public static AccessControlEntry getDenyAllEveryoneACE(Session session, String path) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        for (AccessControlPolicy policy : acm.getPolicies(path)) {
            AccessControlList accessControlList;
            AccessControlEntry[] entries;
            AccessControlEntry denyAllACE;
            if (!(policy instanceof AccessControlList) || (denyAllACE = PrivateFolderAndCollectionUtil.getDenyAllEveryoneACEFromAccessControlEntries(session, entries = (accessControlList = (AccessControlList)policy).getAccessControlEntries())) == null) continue;
            return denyAllACE;
        }
        return null;
    }

    public static boolean isPrivate(Session session, String path) {
        try {
            return PrivateFolderAndCollectionUtil.getDenyAllEveryoneACE(session, path) != null;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public static void addDenyAllEveryoneAsFirstACE(Session session, String path) throws RepositoryException {
        AccessControlUtils.denyAllToEveryone(session, path);
        PrivateFolderAndCollectionUtil.moveDenyAllEveryoneToFirstRestriction(session, path);
    }

    public static void removeDenyAllEveryoneACE(Session session, String path) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        for (AccessControlPolicy policy : acm.getPolicies(path)) {
            if (!(policy instanceof AccessControlList)) continue;
            AccessControlList accessControlList = (AccessControlList)policy;
            AccessControlEntry[] entries = accessControlList.getAccessControlEntries();
            AccessControlEntry denyAllACE = PrivateFolderAndCollectionUtil.getDenyAllEveryoneACEFromAccessControlEntries(session, entries);
            if (denyAllACE != null) {
                accessControlList.removeAccessControlEntry(denyAllACE);
            }
            acm.setPolicy(path, (AccessControlPolicy)accessControlList);
        }
    }

    private static void moveDenyAllEveryoneToFirstRestriction(Session session, String path) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        for (AccessControlPolicy policy : acm.getPolicies(path)) {
            if (!(policy instanceof AccessControlList)) continue;
            AccessControlList accessControlList = (AccessControlList)policy;
            AccessControlEntry[] entries = accessControlList.getAccessControlEntries();
            AccessControlEntry denyAllACE = PrivateFolderAndCollectionUtil.getDenyAllEveryoneACEFromAccessControlEntries(session, entries);
            if (denyAllACE != null) {
                ((JackrabbitAccessControlList)accessControlList).orderBefore(denyAllACE, entries[0]);
            }
            acm.setPolicy(path, (AccessControlPolicy)accessControlList);
        }
    }

    private static AccessControlEntry getDenyAllEveryoneACEFromAccessControlEntries(Session session, AccessControlEntry[] entries) throws RepositoryException {
        for (AccessControlEntry ace : entries) {
            boolean isEveryone = ace.getPrincipal().equals(AccessControlUtils.getEveryonePrincipal(session));
            if (!isEveryone) continue;
            if (ace instanceof JackrabbitAccessControlEntry) {
                boolean isDenyACE;
                boolean bl = isDenyACE = !((JackrabbitAccessControlEntry)ace).isAllow();
                if (!isDenyACE) continue;
            }
            for (Privilege privilege : ace.getPrivileges()) {
                if (!privilege.getName().equalsIgnoreCase("jcr:all")) continue;
                return ace;
            }
        }
        return null;
    }
}

