/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.commons.LabeledResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.text.Text;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIHelper {
    private static final Logger log = LoggerFactory.getLogger(UIHelper.class);
    private static final String CONTENT_FRAGMENT = "contentFragment";
    private static final String ASSET_REPORT_ITEM = "dam/gui/coral/components/admin/reports/viewreport/items/assetreportitem";
    private static final Pattern renditionPattern = Pattern.compile("cq5dam\\.(.*)?\\.(\\d+)\\.(\\d+)\\.(.*)");
    private static final int PATTERN_WIDTH_INDEX = 2;
    private static final int PATTERN_HEIGHT_INDEX = 3;

    public static String getTitle(Resource res) {
        String title = null;
        try {
            Node contentNode;
            Page page;
            Node resNode = res.adaptTo(Node.class);
            if (null != resNode && resNode.isNodeType("dam:Asset")) {
                Node metadata = resNode.getNode("jcr:content/metadata");
                if (metadata != null && metadata.hasProperty("dc:title")) {
                    Property property = metadata.getProperty("dc:title");
                    title = property.isMultiple() ? property.getValues()[0].getString() : property.getValue().getString();
                }
            } else if (null != resNode && resNode.isNodeType("cq:Page") && StringUtils.isBlank(title = (page = res.adaptTo(Page.class)).getPageTitle()) && resNode.hasNode("jcr:content") && (contentNode = resNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                title = contentNode.getProperty("jcr:title").getString();
            }
            if (null == title) {
                LabeledResource lr = res.adaptTo(LabeledResource.class);
                if (lr != null) {
                    title = lr.getTitle();
                } else if (null != resNode && resNode.hasProperty("jcr:title")) {
                    title = resNode.getProperty("jcr:title").getString();
                }
            }
        }
        catch (Exception ex) {
            log.error("error in get title ", ex);
        }
        if (title != null && !title.equals("")) {
            return title;
        }
        return Text.getName(res.getPath());
    }

    public static Rendition getBestfitRendition(Asset asset, int width) {
        List<Rendition> renditions = asset.getRenditions();
        return DamUtil.getBestFitRendition(width, renditions);
    }

    public static String getAltText(Resource resource) {
        String altText = "";
        if (null != resource) {
            ResourceResolver resourceResolver = resource.getResourceResolver();
            ValueMap vm = resource.adaptTo(ValueMap.class);
            if ("dam:Asset".equals(vm.get("jcr:primaryType", String.class))) {
                altText = UIHelper.getAssetAltText(vm);
            } else if (ASSET_REPORT_ITEM.equals(resource.getResourceType())) {
                Resource res = resourceResolver.getResource(resource.getPath());
                if (null != res) {
                    altText = UIHelper.getAssetAltText(res.adaptTo(ValueMap.class));
                }
            } else if (vm.get("jcr:content/contentFragment", false).booleanValue()) {
                altText = UIHelper.getCfmOrCollectionAltText(vm, "jcr:content/");
            } else if (resource.adaptTo(ResourceCollection.class) != null) {
                altText = UIHelper.getCfmOrCollectionAltText(vm, "");
            }
        }
        return StringUtils.isBlank(altText) && null != resource ? resource.getName() : altText;
    }

    private static String getCfmOrCollectionAltText(ValueMap vm, String pathConstant) {
        String altText = "";
        String description = (String)((Object)vm.get(pathConstant + "jcr:description", String.class));
        String title = (String)((Object)vm.get(pathConstant + "jcr:title", String.class));
        if (!StringUtils.isBlank(description)) {
            altText = description;
        } else if (!StringUtils.isBlank(title)) {
            altText = title;
        }
        return altText;
    }

    private static String getAssetAltText(ValueMap vm) {
        String altText = "";
        String description = (String)((Object)vm.get("jcr:content/metadata/dc:description", String.class));
        String title = (String)((Object)vm.get("jcr:content/metadata/dc:title", String.class));
        String name = (String)((Object)vm.get("jcr:content/cq:name", String.class));
        if (!StringUtils.isBlank(description)) {
            altText = description;
        } else if (!StringUtils.isBlank(title)) {
            altText = title;
        } else if (!StringUtils.isBlank(name)) {
            altText = name;
        }
        return altText;
    }

    public static long getCacheKiller(Node node) {
        long ck = 0L;
        try {
            if (node.isNodeType("dam:Asset") || node.isNodeType("nt:file")) {
                if (node.hasProperty("jcr:content/jcr:lastModified")) {
                    ck = node.getProperty("jcr:content/jcr:lastModified").getLong();
                }
            } else if (node.isNodeType("nt:folder")) {
                if (node.hasProperty("jcr:content/folderThumbnail/jcr:content/jcr:lastModified")) {
                    ck = node.getProperty("jcr:content/folderThumbnail/jcr:content/jcr:lastModified").getLong();
                }
            } else if (node.hasProperty("jcr:lastModified")) {
                ck = node.getProperty("jcr:lastModified").getLong();
            }
        }
        catch (Exception e) {
            log.error("error creating cache killer", e);
        }
        return ck / 1000L * 1000L;
    }

    public static Resource getCurrentSuffixResource(SlingHttpServletRequest request) {
        String contentPath = request.getRequestPathInfo().getSuffix();
        Resource res = request.getResourceResolver().getResource(contentPath);
        if (contentPath == null || !contentPath.contains("/content/dam") || res == null) {
            return request.getResourceResolver().getResource("/content/dam");
        }
        return res;
    }

    public static String getSizeLabel(double size) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int i = 0;
        while (size >= 1024.0) {
            size /= 1024.0;
            ++i;
        }
        return (double)Math.round(size * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0) + " " + units[i];
    }

    public static String getSizeLabel(double size, SlingHttpServletRequest slingRequest) {
        Locale locale = slingRequest.getResourceBundle(null).getLocale();
        I18n i18n = new I18n(slingRequest);
        int i = 0;
        while (size >= 1024.0) {
            size /= 1024.0;
            ++i;
        }
        NumberFormat nf = NumberFormat.getInstance(locale);
        String formattedSize = nf.format((double)Math.round(size * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0));
        switch (i) {
            case 0: {
                return i18n.get("{0} B", "Byte", formattedSize);
            }
            case 1: {
                return i18n.get("{0} KB", "KiloByte", formattedSize);
            }
            case 2: {
                return i18n.get("{0} MB", "MegaByte", formattedSize);
            }
            case 3: {
                return i18n.get("{0} GB", "GigaByte", formattedSize);
            }
            case 4: {
                return i18n.get("{0} TB", "TeraByte", formattedSize);
            }
        }
        return "";
    }

    public static String getResolutionLabel(long width, long height, SlingHttpServletRequest slingRequest) {
        Locale locale = slingRequest.getResourceBundle(null).getLocale();
        I18n i18n = new I18n(slingRequest);
        NumberFormat nf = NumberFormat.getInstance(locale);
        String formattedWidth = nf.format(width);
        String formattedHeight = nf.format(height);
        return i18n.get("{0} x {1}", "width x height, image resolution", formattedWidth, formattedHeight);
    }

    public static boolean hasPermission(AccessControlManager acm, Resource res, String privilege) throws RepositoryException {
        Privilege p = acm.privilegeFromName(privilege);
        return acm.hasPrivileges(res.getPath(), new Privilege[]{p});
    }

    public static Privilege[] getAllPermission(AccessControlManager acm, Resource res) throws PathNotFoundException, RepositoryException {
        HashSet<Privilege> allPrivileges = new HashSet<Privilege>();
        Privilege jcrAllPriv = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        for (Privilege p : acm.getPrivileges(res.getPath())) {
            if (p.isAggregate() && !jcrAllPriv.equals(p)) {
                Collections.addAll(allPrivileges, p.getAggregatePrivileges());
            }
            allPrivileges.add(p);
        }
        return allPrivileges.toArray(new Privilege[0]);
    }

    public static boolean isEditSupportedFormat(String mimetype) {
        String[] supportedTypes;
        for (String type : supportedTypes = new String[]{"image/jpg", "image/jpeg", "image/png", "image/gif", "image/bmp"}) {
            if (!type.equalsIgnoreCase(mimetype)) continue;
            return true;
        }
        return false;
    }

    public static Rendition getBestFitRendtionBasedOnSize(Asset asset, long size) {
        return UIHelper.getBestFitRendtionBasedOnSize(asset, size, false);
    }

    public static Rendition getBestFitRendtionBasedOnSize(Asset asset, long size, boolean preferOriginal) {
        try {
            long sizeinBytes = size * 1024L;
            List<Rendition> renditions = asset.getRenditions();
            SizeBasedRenditionComparator comp = new SizeBasedRenditionComparator();
            Collections.sort(renditions, comp);
            Iterator<Rendition> itr = renditions.iterator();
            Rendition bestFit = null;
            while (itr.hasNext()) {
                Rendition rend = itr.next();
                if (!UIHelper.canRenderOnWeb(rend.getMimeType()) || rend.getSize() > sizeinBytes) continue;
                bestFit = rend;
            }
            if (bestFit == null) {
                for (Rendition rend : renditions) {
                    if (!UIHelper.canRenderOnWeb(rend.getMimeType())) continue;
                    bestFit = rend;
                    break;
                }
            } else if (preferOriginal && UIHelper.canRenderOnWeb(asset.getOriginal().getMimeType()) && bestFit.getSize() > asset.getOriginal().getSize()) {
                return asset.getOriginal();
            }
            return bestFit;
        }
        catch (Exception e) {
            log.error("Error occured while getting best fit rendition ", e);
            return null;
        }
    }

    public static boolean canRenderOnWeb(String mimeType) {
        return mimeType != null && (mimeType.toLowerCase().contains("jpeg") || mimeType.toLowerCase().contains("jpg") || mimeType.toLowerCase().contains("gif") || mimeType.toLowerCase().contains("png") || mimeType.toLowerCase().contains("bmp"));
    }

    public static int getWidth(Rendition r) {
        return UIHelper.getDimension(r, "tiff:ImageWidth");
    }

    public static int getHeight(Rendition r) {
        return UIHelper.getDimension(r, "tiff:ImageLength");
    }

    private static int getDimension(Rendition r, String dimensionProperty) {
        if (r == null) {
            log.debug("Null rendition at", new Exception("Null rendition"));
            return 0;
        }
        if (dimensionProperty == null || !dimensionProperty.equals("tiff:ImageLength") && !dimensionProperty.equals("tiff:ImageWidth")) {
            log.warn("Incorrect dimension property for {}", (Object)r.getPath(), (Object)new Exception("Invalid property name " + dimensionProperty));
            return 0;
        }
        String name = r.getName();
        if (name == null) {
            log.warn("Null name returned at {}", (Object)r.getPath());
            return 0;
        }
        try {
            if (name.equals("original")) {
                Asset asset = r.adaptTo(Asset.class);
                if (asset == null) {
                    log.debug("Rendition at {} is not adaptable to an asset.", (Object)r.getPath());
                    return 0;
                }
                String val = asset.getMetadataValue(dimensionProperty);
                if (val == null || val.length() == 0) {
                    log.debug("Unable to find metadata property {} for {}", (Object)dimensionProperty, (Object)asset.getPath());
                    return 0;
                }
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Metadata property {} was {} and not a number at {}", dimensionProperty, val, asset.getPath());
                    return 0;
                }
            }
            Matcher matcher = renditionPattern.matcher(name);
            if (matcher.matches()) {
                int matcherIndex = "tiff:ImageLength".equals(dimensionProperty) ? 3 : 2;
                int renditionHeight = Integer.parseInt(matcher.group(matcherIndex));
                return renditionHeight;
            }
            log.debug("Unknown naming format for name {} at {}", (Object)name, (Object)r.getPath());
            return 0;
        }
        catch (Exception e) {
            log.warn("Unexpected exception finding dimension for asset at {} " + r.getPath(), e);
            return 0;
        }
    }

    @Deprecated
    public static String lookupMimeType(String mimeType, Node node, boolean uppercase) {
        throw new UnsupportedOperationException("This API has been deprecated. Use lookupMimeType(String, Resource, uppercase) instead.");
    }

    public static String lookupMimeType(String mimeType, Resource resource, boolean uppercase) {
        try {
            if (resource == null || mimeType == null) {
                return null;
            }
            Iterator<Resource> it = resource.listChildren();
            while (it.hasNext()) {
                Resource child = it.next();
                ValueMap childVM = child.adaptTo(ValueMap.class);
                String mimetypes = (String)((Object)childVM.get("mimetypes", String.class));
                Object[] mimetypesList = mimetypes.split(",");
                if (!ArrayUtils.contains(mimetypesList, mimeType.toUpperCase())) continue;
                if (uppercase) {
                    return (String)((Object)childVM.get("jcr:description", String.class));
                }
                return (String)((Object)childVM.get("jcr:title", String.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static boolean isCheckedOutByDrive(Asset asset) {
        try {
            Node assetNode = asset.adaptTo(Node.class);
            Node jcrContent = assetNode.getNode("jcr:content");
            if (jcrContent != null && jcrContent.hasProperty("cq:drivelock")) {
                return true;
            }
        }
        catch (PathNotFoundException e) {
            log.warn("Asset does not exists ", e);
        }
        catch (RepositoryException e) {
            log.warn("Respoitory execption", e);
        }
        return false;
    }

    public static String getCheckedOutby(Asset asset) {
        if (UIHelper.isCheckedOutByDrive(asset)) {
            try {
                Node assetNode = asset.adaptTo(Node.class);
                Node jcrContent = assetNode.getNode("jcr:content");
                return jcrContent.getProperty("cq:drivelock").getString();
            }
            catch (PathNotFoundException e) {
                log.warn("Asset does not exists ", e);
            }
            catch (ValueFormatException e) {
                log.warn("Value format exception ", e);
            }
            catch (RepositoryException e) {
                log.warn("Respoitory execption", e);
            }
        }
        return "";
    }

    public static List<String> getAssetActionRels(ActionRelsResourceProperties resource, ActionRelsUserProperties user, ActionRelsRequestProperties request) {
        List<String> actionRels = null;
        if (resource != null && user != null && request != null) {
            actionRels = UIHelper.getAssetActionRels(user.hasJcrRead, user.hasJcrWrite, user.hasAddChild, user.canEdit, user.canAnnotate, user.isAdmin, resource.isAssetExpired, resource.isSubAssetExpired, resource.isContentFragment, resource.isArchive, resource.isSnippetTemplate, resource.isDownloadable, request.isOmniSearchRequest, resource.isStockAsset, resource.isStockAssetLicensed, resource.isStockAccessible, request.isLiveCopy);
            if (actionRels == null) {
                actionRels = new ArrayList<String>();
            }
            if (actionRels != null && resource.canFindSimilar) {
                actionRels.add("cq-damadmin-admin-actions-findsimilar-activator");
            }
        }
        return actionRels;
    }

    public static List<String> getAssetActionRels(boolean hasJcrRead, boolean hasJcrWrite, boolean hasAddChild, boolean canEdit, boolean canAnnotate, boolean isAdmin, boolean isAssetExpired, boolean isSubAssetExpired, boolean isContentFragment, boolean isArchive, boolean isSnippetTemplate, boolean isDownloadable, boolean isOmniSearchRequest, boolean isStockAsset, boolean isStockAssetLicensed, boolean isStockAccessible, boolean isLiveCopy) {
        ArrayList<String> actionRels = new ArrayList<String>();
        actionRels.add("cq-damadmin-admin-actions-createworkflow");
        if (canEdit && isContentFragment && isOmniSearchRequest) {
            actionRels.add("aem-assets-admin-actions-edit-fragment-activator");
        }
        if (hasJcrRead) {
            if (!isContentFragment) {
                actionRels.add("foundation-damadmin-properties-activator");
            } else {
                actionRels.add("foundation-damadmin-fragmentprops-activator");
            }
            actionRels.add("cq-damadmin-admin-actions-add-to-collection-activator");
            actionRels.add("cq-damadmin-admin-actions-desktop-activator");
            actionRels.add("cq-damadmin-admin-actions-opendesktop");
            actionRels.add("cq-damadmin-admin-actions-editdesktop");
            actionRels.add("cq-damadmin-admin-actions-revealdesktop");
            actionRels.add("aem-assets-admin-actions-moderatetags-activator");
        }
        if (hasJcrWrite) {
            actionRels.add("cq-damadmin-admin-actions-open-activator");
            actionRels.add("aem-assets-admin-actions-shoppableedit-activator");
            actionRels.add("cq-damadmin-admin-actions-createversion");
            if (!isContentFragment) {
                actionRels.add("cq-damadmin-admin-actions-createlivecopy");
                if (!isLiveCopy) {
                    actionRels.add("cq-siteadmin-admin-actions-relate-activator");
                    actionRels.add("cq-siteadmin-admin-actions-unrelate-activator");
                    actionRels.add("dam-asset-reprocessassets-action-activator");
                }
            }
        }
        if (hasAddChild) {
            actionRels.add("cq-damadmin-admin-actions-open-activator");
            actionRels.add("icon-note");
        }
        if (canEdit && (isAdmin || !isAssetExpired)) {
            if (!isContentFragment || !isOmniSearchRequest) {
                actionRels.add("aem-assets-admin-actions-edit-activator");
            }
            actionRels.add("dam-assetedit-action-select");
        }
        if (canAnnotate && !isLiveCopy) {
            actionRels.add("aem-assets-admin-actions-annotate-activator");
            actionRels.add("cq-project-admin-actions-annotate-activator");
        }
        if ((isAdmin || !isAssetExpired && !isSubAssetExpired) && isDownloadable) {
            if (!isContentFragment) {
                actionRels.add("cq-damadmin-admin-actions-download-activator");
            } else {
                actionRels.add("cq-damadmin-admin-actions-downloadcf-activator");
            }
        }
        if (isArchive) {
            actionRels.add("cq-damadmin-admin-actions-extract-activator");
        }
        if (hasJcrWrite && isSnippetTemplate) {
            actionRels.add("cq-damadmin-admin-actions-createsnippet-activator");
        }
        if (isStockAccessible && isStockAsset) {
            actionRels.add("cq-damadmin-admin-actions-stock-viewsimilar-activator");
            actionRels.add("cq-damadmin-admin-actions-stock-viewexternal-activator");
            if (!isStockAssetLicensed) {
                actionRels.add("cq-damadmin-admin-actions-stock-license-activator");
            } else {
                actionRels.add("cq-damadmin-admin-actions-stock-licenseagain-activator");
            }
        }
        return actionRels;
    }

    public static List<String> getDirectoryActionRels(boolean hasJcrRead, boolean hasModifyAccessControl, boolean hasJcrWrite, boolean hasReplicate, boolean isMACShared, boolean isCCShared, boolean isRootMACShared, boolean isMPShared, boolean isRootMPShared, boolean isLiveCopy) {
        ArrayList<String> actionRels = new ArrayList<String>();
        actionRels.add("cq-damadmin-admin-actions-createworkflow");
        if (hasJcrRead) {
            actionRels.add("icon-share");
            actionRels.add("cq-damadmin-admin-actions-download-activator");
            actionRels.add("cq-damadmin-admin-actions-add-to-collection-activator");
            actionRels.add("cq-damadmin-admin-actions-revealdesktop");
            actionRels.add("aem-assets-admin-actions-moderatetags-activator");
            actionRels.add("cq-damadmin-admin-actions-foldershare");
        }
        if (hasModifyAccessControl) {
            actionRels.add("cq-damadmin-admin-actions-adhocassetshare-activator");
        }
        if (hasJcrWrite) {
            actionRels.add("cq-damadmin-admin-actions-fileupload-at-activator");
            actionRels.add("cq-damadmin-admin-actions-createfolder-at-activator");
            actionRels.add("cq-damadmin-admin-actions-imageset-at-activator");
            actionRels.add("cq-damadmin-admin-actions-spinset-at-activator");
            actionRels.add("cq-damadmin-admin-actions-mixedmedia-at-activator");
            actionRels.add("cq-damadmin-admin-actions-createcarousel-at-activator");
            actionRels.add("cq-damadmin-admin-actions-createfragment-at-activator");
            actionRels.add("cq-damadmin-admin-actions-createlivecopy");
            actionRels.add("dam-asset-exportmetadata-action-activator");
            actionRels.add("dam-asset-reprocessassets-action-activator");
            if (!isLiveCopy) {
                actionRels.add("dam-asset-createtask-action-activator");
            }
        }
        if (hasJcrWrite && hasReplicate) {
            actionRels.add("cq-damadmin-admin-actions-macshare-activator");
            actionRels.add("cq-damadmin-admin-actions-ccshare-activator");
            actionRels.add("cq-damadmin-admin-actions-mpshare-activator");
        }
        if (isMACShared || isCCShared || isRootMACShared || isMPShared || isRootMPShared) {
            actionRels.remove("cq-damadmin-admin-actions-move-activator");
            actionRels.remove("cq-damadmin-admin-actions-delete-activator");
        }
        return actionRels;
    }

    public static class ActionRelsRequestProperties {
        boolean isOmniSearchRequest = false;
        boolean isLiveCopy = false;

        ActionRelsRequestProperties() {
        }

        public static ActionRelsRequestProperties create(boolean isOmniSearchRequest, boolean isLiveCopy) {
            ActionRelsRequestProperties req = new ActionRelsRequestProperties();
            req.isOmniSearchRequest = isOmniSearchRequest;
            req.isLiveCopy = isLiveCopy;
            return req;
        }
    }

    public static class ActionRelsUserProperties {
        boolean hasJcrRead = false;
        boolean hasJcrWrite = false;
        boolean hasAddChild = false;
        boolean canEdit = false;
        boolean canAnnotate = false;
        boolean isAdmin = false;

        ActionRelsUserProperties() {
        }

        public static ActionRelsUserProperties create(boolean hasJcrRead, boolean hasJcrWrite, boolean hasAddChild, boolean canEdit, boolean canAnnotate, boolean isAdmin) {
            ActionRelsUserProperties obj = new ActionRelsUserProperties();
            obj.hasJcrRead = hasJcrRead;
            obj.hasJcrWrite = hasJcrWrite;
            obj.hasAddChild = hasAddChild;
            obj.canEdit = canEdit;
            obj.canAnnotate = canAnnotate;
            obj.isAdmin = isAdmin;
            return obj;
        }
    }

    public static class ActionRelsResourceProperties {
        public boolean isAssetExpired = false;
        public boolean isSubAssetExpired = false;
        public boolean isContentFragment = false;
        public boolean isArchive = false;
        public boolean isSnippetTemplate = false;
        public boolean isDownloadable = false;
        public boolean isStockAsset = false;
        public boolean isStockAssetLicensed = false;
        public boolean isStockAccessible = false;
        public boolean canFindSimilar = false;

        ActionRelsResourceProperties() {
        }

        public static ActionRelsResourceProperties create(boolean isAssetExpired, boolean isSubAssetExpired, boolean isContentFragment, boolean isArchive, boolean isSnippetTemplate, boolean isDownloadable, boolean isStockAsset, boolean isStockAssetLicensed, boolean isStockAccessible, boolean canFindSimilar) {
            ActionRelsResourceProperties obj = new ActionRelsResourceProperties();
            obj.isAssetExpired = isAssetExpired;
            obj.isSubAssetExpired = isSubAssetExpired;
            obj.isContentFragment = isContentFragment;
            obj.isArchive = isArchive;
            obj.isSnippetTemplate = isSnippetTemplate;
            obj.isDownloadable = isDownloadable;
            obj.isStockAsset = isStockAsset;
            obj.isStockAssetLicensed = isStockAssetLicensed;
            obj.isStockAccessible = isStockAccessible;
            obj.canFindSimilar = canFindSimilar;
            return obj;
        }
    }

    private static class SizeBasedRenditionComparator
    implements Comparator<Rendition> {
        private SizeBasedRenditionComparator() {
        }

        @Override
        public int compare(Rendition r1, Rendition r2) {
            if (r1.getSize() < r2.getSize()) {
                return -1;
            }
            if (r1.getSize() == r2.getSize()) {
                return 0;
            }
            return 1;
        }
    }
}

