/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WebEnabledImageCreator {
    private static final Logger log = LoggerFactory.getLogger(WebEnabledImageCreator.class);
    private static final String WEB_SPECIFIER = "web";
    private Asset asset;
    private MimeTypeService mimeTypeService;

    @Deprecated
    public WebEnabledImageCreator(Asset asset, MimeTypeService mimeTypeService) {
        this.asset = asset;
        this.mimeTypeService = mimeTypeService;
    }

    @Deprecated
    public void create(BufferedImage image, String defaultMimetype, String dimensions, String keepFormat, String qualityStr, boolean force) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("No longer supported. Use com.day.cq.dam.api.renditions.RenditionMaker service instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImage(Asset asset, Layer layer, String mimetype, double quality, String renditionName) throws IOException {
        File tmpFile = File.createTempFile(WEB_SPECIFIER, "." + this.getExtension(mimetype));
        FileOutputStream out = FileUtils.openOutputStream(tmpFile);
        FileInputStream is = null;
        try {
            layer.write(mimetype, quality, out);
            is = FileUtils.openInputStream(tmpFile);
            asset.addRendition(renditionName, (InputStream)is, mimetype);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(is);
            FileUtils.deleteQuietly(tmpFile);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(is);
        FileUtils.deleteQuietly(tmpFile);
    }

    protected Layer createImage(BufferedImage image, int maxWidth, int maxHeight) {
        long startTime = System.currentTimeMillis();
        Layer layer = new Layer(image);
        int height = layer.getHeight();
        int width = layer.getWidth();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = Math.round((float)width * (float)maxHeight / (float)height);
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = Math.round((float)height * (float)maxWidth / (float)width);
                }
            } else {
                newWidth = maxWidth;
                newHeight = Math.round((float)height * (float)maxWidth / (float)width);
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = Math.round((float)width * (float)maxHeight / (float)height);
                }
            }
            layer.resize(newWidth, newHeight);
        }
        if (this.asset.getName().endsWith(".gif")) {
            layer.setTransparency(new Color(-991024));
        }
        log.debug("createImage took " + (System.currentTimeMillis() - startTime) + "ms");
        return layer;
    }

    protected String getExtension(String mimetype) {
        return this.mimeTypeService.getExtension(mimetype);
    }

    protected String getMimeType(Asset asset) {
        String name = asset.getName().toLowerCase();
        return this.mimeTypeService.getMimeType(name);
    }

    protected Integer[] getDimension(String dimensions) {
        if (dimensions != null) {
            String[] splits = dimensions.split(":");
            Integer[] d = new Integer[]{Integer.valueOf(splits[0]), Integer.valueOf(splits[1])};
            return d;
        }
        return new Integer[]{1000, 1000};
    }

    protected double getQuality(double base, String qualityStr) {
        int q = Integer.valueOf(qualityStr);
        double res = base * (double)q / 100.0;
        return res;
    }
}

