/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.cq.dam.mac.sync.helper.FolderSyncHelper;
import com.adobe.cq.dam.mac.sync.helper.FolderSyncRequest;
import com.adobe.cq.dam.mac.sync.helper.FolderSyncResponse;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Properties(value={@Property(name="service.description", value={"Scheduled Publish/Unpublish of Assets to Brand Portal"}), @Property(name="process.label", value={"Scheduled Publish Brand Portal"})})
public abstract class AbstractScheduledReplicationBPProcess
implements WorkflowProcess {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String repType = "mediaportal";
    private static final String operation = "dam.mac.sync";
    private static final String SERVICE_USER_ID = "assetidhelper";
    @Reference
    private SlingRepository repository;
    @Reference
    private FolderSyncHelper folderSyncHelper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metadataMap) throws WorkflowException {
        try (ResourceResolver userResourceResolver = null;){
            FolderSyncResponse response;
            this.log.info("Stating scheduled publish/unpublish to BrandPortal ..");
            WorkflowData data = workItem.getWorkflowData();
            String path = (String)data.getPayload();
            userResourceResolver = this.getInitiatorResolver(workItem);
            FolderSyncRequest request = new FolderSyncRequest();
            request.setType(repType);
            request.setOperation(operation);
            request.setContextPath("");
            request.setPaths(new String[]{path});
            request.setUserResourceResolver(userResourceResolver);
            if (this.getReplicationType() == REPTYPE.UNPUBLISH) {
                request.setDisableSync("disable");
            }
            this.log.info("Finished scheduled publish/unpublish to BrandPortal. success = {}", (Object)((response = this.folderSyncHelper.process(request)).getStatus() == null ? 1 : 0));
        }
    }

    private ResourceResolver getInitiatorResolver(WorkItem workItem) throws LoginException, RepositoryException, org.apache.sling.api.resource.LoginException {
        String initiator = workItem.getWorkflow().getInitiator();
        Session initiatorSession = this.getUserSession(initiator);
        return this.getResourceResolver(initiatorSession);
    }

    private Session getUserSession(String userId) throws LoginException, RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials(userId, new char[0]);
        return this.repository.impersonateFromService(SERVICE_USER_ID, (Credentials)credentials, null);
    }

    protected ResourceResolver getResourceResolver(Session session) throws org.apache.sling.api.resource.LoginException {
        return this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
    }

    protected abstract REPTYPE getReplicationType();

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindFolderSyncHelper(FolderSyncHelper folderSyncHelper) {
        this.folderSyncHelper = folderSyncHelper;
    }

    protected void unbindFolderSyncHelper(FolderSyncHelper folderSyncHelper) {
        if (this.folderSyncHelper == folderSyncHelper) {
            this.folderSyncHelper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected static enum REPTYPE {
        PUBLISH,
        UNPUBLISH;

    }
}

