/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.api.renditions.RenditionTemplate;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.process.CreateThumbnailProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Create Web Enabled Image"})
public class CreateWebEnabledImageProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateWebEnabledImageProcess.class);
    @Reference
    protected RenditionMaker renditionMaker;

    public void createWebEnabledImage(WorkItem workItem, Config config, Asset asset, RenditionMaker renditionMaker) throws RepositoryException {
        String lastModified;
        if (this.handleAsset(asset, config)) {
            asset.setBatchMode(true);
            RenditionTemplate template = renditionMaker.createWebRenditionTemplate(asset, config.width, config.height, config.quality, config.mimeType, config.mimeTypesToKeep);
            renditionMaker.generateRenditions(asset, template);
        }
        Node assetNode = asset.adaptTo(Node.class);
        Node content = assetNode.getNode("jcr:content");
        String resolvedUser = (String)((Object)workItem.getWorkflowData().getMetaDataMap().get("userId", String.class));
        Rendition rendition = asset.getRendition("original");
        if (rendition != null && StringUtils.isNotBlank(lastModified = (String)rendition.getProperties().get("jcr:lastModifiedBy"))) {
            resolvedUser = lastModified;
        }
        content.setProperty("jcr:lastModifiedBy", resolvedUser);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
    }

    private boolean isWebThumbnailStale(Asset asset, int width, int height) {
        String pngName = "cq5dam.web." + String.valueOf(width) + "." + String.valueOf(height) + ".png";
        String jpegName = "cq5dam.web." + String.valueOf(width) + "." + String.valueOf(height) + ".jpeg";
        return CreateThumbnailProcess.isThumbnailStale(asset, pngName) && CreateThumbnailProcess.isThumbnailStale(asset, jpegName);
    }

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        if (asset == null) {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot create web enabled image, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
        Config config = this.parseConfig(metaData);
        try {
            this.createWebEnabledImage(workItem, config, asset, this.renditionMaker);
        }
        catch (RepositoryException re) {
            throw new WorkflowException(re);
        }
    }

    public Config parseConfig(MetaDataMap metaData) {
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (StringUtils.isNotEmpty(processArgs)) {
            return this.parseLegacyConfig(processArgs);
        }
        Config cfg = new Config();
        cfg.width = metaData.get(Arguments.WIDTH.name(), 1000L).intValue();
        cfg.height = metaData.get(Arguments.HEIGHT.name(), 1000L).intValue();
        cfg.mimeType = metaData.get(Arguments.MIME_TYPE.name(), "image/png");
        cfg.quality = metaData.get(Arguments.QUALITY.name(), cfg.mimeType.equals("image/gif") ? 256L : 60L).intValue();
        cfg.mimeTypesToKeep = metaData.get(Arguments.KEEP_FORMAT_LIST.name(), new String[]{"image/pjpeg", "image/jpeg", "image/jpg", "image/gif", "image/png", "image/x-png"});
        cfg.skipMimeTypes = metaData.get(Arguments.SKIP.name(), new String[0]);
        return cfg;
    }

    private Config parseLegacyConfig(String processArgs) {
        Config cfg = new Config();
        String[] args = processArgs.split(",");
        String dimension = this.getFirstValueFromArgs(args, Arguments.DIMENSION.legacyName, null);
        if (dimension == null) {
            cfg.width = 1000;
            cfg.height = 1000;
        } else {
            String[] dim = dimension.split(":");
            cfg.width = Integer.valueOf(dim[0]);
            cfg.height = Integer.valueOf(dim[1]);
        }
        cfg.mimeType = this.getFirstValueFromArgs(args, Arguments.MIME_TYPE.legacyName, "image/png");
        String keepFormat = this.getFirstValueFromArgs(args, Arguments.KEEP_FORMAT_LIST.legacyName, "image/pjpeg,image/jpeg,image/jpg,image/gif,image/png,image/x-png");
        cfg.mimeTypesToKeep = keepFormat.split(",");
        String qualityStr = this.getFirstValueFromArgs(args, Arguments.QUALITY.legacyName, cfg.mimeType.equals("image/gif") ? "256" : "60");
        cfg.quality = Integer.valueOf(qualityStr);
        List<String> values = this.getValuesFromArgs(Arguments.SKIP.legacyName, args);
        cfg.skipMimeTypes = values.toArray(new String[values.size()]);
        return cfg;
    }

    private String getFirstValueFromArgs(String[] arguments, String key, String defaultValue) {
        List<String> values = this.getValuesFromArgs(key, arguments);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return defaultValue;
    }

    protected boolean handleAsset(Asset asset, Config config) {
        if (asset == null || config.skipMimeTypes == null) {
            return true;
        }
        String mimeType = asset.getMimeType();
        if (mimeType == null) {
            return true;
        }
        for (String val : config.skipMimeTypes) {
            if (!mimeType.matches(val)) continue;
            log.debug(this.getClass().getName() + " skipped for MIME type: " + mimeType);
            return false;
        }
        return true;
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }

    public static class Config {
        public int width;
        public int height;
        public int quality;
        public String mimeType;
        public String[] mimeTypesToKeep;
        public String[] skipMimeTypes;
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        DIMENSION("dimension"),
        WIDTH("width"),
        HEIGHT("height"),
        QUALITY("quality"),
        MIME_TYPE("mimetype"),
        KEEP_FORMAT_LIST("keepFormatList"),
        SKIP("skip");

        public final String legacyName;

        private Arguments(String legacyName) {
            this.legacyName = legacyName;
        }
    }
}

