/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Delete Dam Asset"})
public class DeleteDamAssetProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(DeleteDamAssetProcess.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private PayloadMap payloadMap;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        String[] args = this.buildArguments(metaData);
        if (args.length == 2) {
            String srcPrefix = args[0];
            String dstPrefix = args[1];
            try {
                Session session = workflowSession.getSession();
                String srcPath = workItem.getWorkflowData().getPayload().toString();
                String dstPath = srcPath.replaceAll(srcPrefix, dstPrefix);
                if (session.itemExists(dstPath) && !this.payloadMap.isInWorkflow(dstPath, true)) {
                    session.getItem(dstPath).remove();
                    session.save();
                }
            }
            catch (RepositoryException e) {
                log.error("execute: error while deleting asset; work item [{}]: ", (Object)workItem.getId(), (Object)e);
            }
        } else {
            throw new IllegalArgumentException("Insufficient arguments specified");
        }
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String sourceRoot = (String)((Object)metaData.get(Arguments.SOURCE_ROOT.name(), String.class));
        String destinationRoot = (String)((Object)metaData.get(Arguments.DESTINATION_ROOT.name(), String.class));
        if (StringUtils.isNotBlank(sourceRoot)) {
            arguments.add(this.appendSlash(sourceRoot));
        }
        if (StringUtils.isNotBlank(destinationRoot)) {
            arguments.add(this.appendSlash(destinationRoot));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private String appendSlash(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }

    public static enum Arguments {
        PROCESS_ARGS,
        SOURCE_ROOT,
        DESTINATION_ROOT;

    }
}

