/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
@Properties(value={@Property(name="process.label", value={"Delete Image Previews Process"})})
public class DeleteImagePreviewProcess
extends AbstractAssetWorkflowProcess {
    @Override
    public void execute(WorkItem item, WorkflowSession wfSession, MetaDataMap args) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(item, wfSession.getSession());
        if (null != asset) {
            Rendition r = asset.getImagePreviewRendition();
            String name = r.getName();
            if (name != null && !"original".equals(name)) {
                asset.removeRendition(name);
            }
        } else {
            String wfPayload = item.getWorkflowData().getPayload().toString();
            String message = "execute: cannot delete image preview, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + item.getId() + "}].";
            throw new WorkflowException(message);
        }
    }
}

