/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Gate Keeper"})
public class GateKeeperProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(GateKeeperProcess.class);
    private static final String NT_LIVE_SYNC = "cq:LiveSync";
    private static final String NT_LIVE_RELATION = "cq:LiveRelationship";
    private static final String NT_LIVE_SYNC_CANCELLED = "cq:LiveSyncCancelled";

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        block13: {
            try {
                Session session = workflowSession.getSession();
                Asset asset = this.getAssetFromPayload(workItem, session);
                if (null != asset) {
                    Node assetNode = asset.adaptTo(Node.class);
                    boolean isLiveCopy = this.isLiveCopy(assetNode);
                    if (asset.getOriginal().getSize() == 0L || assetNode.hasProperty("jcr:content/restored") || isLiveCopy) {
                        if (assetNode.hasProperty("jcr:content/restored")) {
                            assetNode.getNode("jcr:content").getProperty("restored").remove();
                            log.debug("It is a restored asset[{}], no processing needed. terminating workflow...", (Object)asset.getPath());
                        } else if (isLiveCopy) {
                            log.debug("Asset is a live copy and should not be touched by workflows", (Object)asset.getPath());
                        } else {
                            log.debug("File size is ZERO. terminating workflow...", (Object)asset.getPath());
                        }
                        workflowSession.terminateWorkflow(workItem.getWorkflow());
                        log.debug("execute: terminated workflow for asset [{}] .", (Object)asset.getPath());
                    } else if (!metaData.containsKey("PROCESS_AUTO_ADVANCE") || !((Boolean)((Object)metaData.get("PROCESS_AUTO_ADVANCE", Boolean.class))).booleanValue()) {
                        boolean advanced = false;
                        List<Route> routes = workflowSession.getRoutes(workItem);
                        for (Route route : routes) {
                            if (!route.hasDefault()) continue;
                            workflowSession.complete(workItem, route);
                            advanced = true;
                            break;
                        }
                        if (!advanced) {
                            workflowSession.complete(workItem, routes.get(0));
                        }
                        this.setAssetState(assetNode, session);
                    } else {
                        this.setAssetState(assetNode, session);
                    }
                    break block13;
                }
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: gatekeeping failed, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            catch (Exception e) {
                throw new WorkflowException(e);
            }
        }
    }

    private void setAssetState(Node assetNode, Session session) {
        String nodePath = "";
        try {
            nodePath = assetNode.getPath();
            if (assetNode.getNode("jcr:content") != null) {
                if (!assetNode.getNode("jcr:content").hasProperty("dam:assetState")) {
                    assetNode.getNode("jcr:content").setProperty("dam:assetState", "processing");
                    session.save();
                } else if (!assetNode.getNode("jcr:content").getProperty("dam:assetState").getString().equals("processing")) {
                    assetNode.getNode("jcr:content").setProperty("dam:assetState", "processing");
                    session.save();
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("Unable to set asset state of node %s", nodePath), e);
        }
    }

    private boolean isLiveCopy(Node assetNode) {
        try {
            Node content = assetNode.getNode("jcr:content");
            if ((content.isNodeType(NT_LIVE_SYNC) || content.isNodeType(NT_LIVE_RELATION)) && !content.isNodeType(NT_LIVE_SYNC_CANCELLED)) {
                Node renditions = content.getNode("renditions");
                return !renditions.isNodeType(NT_LIVE_SYNC_CANCELLED);
            }
        }
        catch (PathNotFoundException e) {
            log.debug("error in checking live copy", e);
        }
        catch (RepositoryException e) {
            log.debug("error in checking live copy", e);
        }
        return false;
    }
}

