/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.core.XMPArray;
import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.XMPNode;
import com.adobe.xmp.core.XMPSimple;
import com.adobe.xmp.core.XMPStruct;
import com.adobe.xmp.core.parser.RDFXMLParser;
import com.adobe.xmp.core.parser.RDFXMLParserContext;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.xmp.XMPHandler;
import com.day.cq.dam.api.handler.xmp.XMPWriteBackOptions;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.metadata.XmpFilter;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.impl.handler.xmp.XMPWriteBackOptionsImpl;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="process.label", value={"XMP Writeback"})})
public class XMPWritebackProcess
extends AbstractAssetWorkflowProcess {
    private static final String PS_AUX_ISO = "psAux:ISO";
    private static final String EXIF_FLASH = "Flash";
    private static final int MAGIC_SIZE = 1024;
    private static final String EPS_MIMETYPE = "application/postscript";
    private static final byte[] PS_START = "%!".getBytes();
    private static final byte[] PS_ADOBE = "PS-Adobe-".getBytes();
    private static final byte[] EPS_TYPE = "EPS".getBytes();
    private static final Logger log = LoggerFactory.getLogger(XMPWritebackProcess.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected XMPHandler xmpHandler;
    @Reference
    private XmpFilter xmpFilter;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        block26: {
            if (null == this.xmpHandler) {
                log.warn("XMP Writeback is not supported on this platform or required libraries are missing !!!");
                workflowSession.terminateWorkflow(workItem.getWorkflow());
                return;
            }
            String[] args = this.buildArguments(metaDataMap);
            String payloadPath = null;
            if (workItem.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
                payloadPath = workItem.getWorkflowData().getPayload().toString();
            }
            log.info("payload path :" + payloadPath);
            Session session = workflowSession.getSession();
            Asset asset = this.getAssetFromPayload(workItem, session);
            String userId = (String)((Object)workItem.getWorkflowData().getMetaDataMap().get("userId", String.class));
            if (null != asset && null != payloadPath) {
                try {
                    Node assetNode = asset.adaptTo(Node.class);
                    Node content = assetNode.getNode("jcr:content");
                    Node payloadNode = session.getNode(payloadPath);
                    if (payloadNode.hasProperty("newRendition")) {
                        log.debug("Skipping the {} execution.", (Object)XMPWritebackProcess.class.getName());
                        payloadNode.getProperty("newRendition").remove();
                        session.save();
                        workflowSession.terminateWorkflow(workItem.getWorkflow());
                        return;
                    }
                    if (content.hasProperty("newRendition")) {
                        log.debug("Skipping the {} execution.", (Object)XMPWritebackProcess.class.getName());
                        content.getProperty("newRendition").remove();
                        session.save();
                        workflowSession.terminateWorkflow(workItem.getWorkflow());
                        break block26;
                    }
                    String mime = asset.getMimeType();
                    boolean createVersion = true;
                    if (args.length > 0) {
                        boolean bl = createVersion = "true".equals(this.getValuesFromArgs("createversion", args).get(0));
                    }
                    if (this.xmpHandler.isSupported(mime) && this.isWritebackSupported(asset)) {
                        XMPWriteBackOptionsImpl writeBackOptions = new XMPWriteBackOptionsImpl();
                        writeBackOptions.createVersion(createVersion);
                        List<String> renditions = this.getValuesFromArgs("rendition", args);
                        HashSet<Rendition> XMPWriteBackRenditions = new HashSet<Rendition>();
                        for (String rendition : renditions) {
                            Rendition currentRendition = asset.getRendition(rendition);
                            if (null == currentRendition) continue;
                            XMPWriteBackRenditions.add(currentRendition);
                        }
                        writeBackOptions.setRenditions(XMPWriteBackRenditions);
                        this.writeXmp(asset, workItem, workflowSession, (XMPWriteBackOptions)writeBackOptions);
                        Rendition orgRen = asset.getOriginal();
                        Node orgRendNode = orgRen.adaptTo(Node.class);
                        Node orgRendContNode = orgRendNode.getNode("jcr:content");
                        try (InputStream is = orgRen.getStream();){
                            String sha1 = DigestUtils.shaHex(is);
                            Node metaData = asset.adaptTo(Node.class).getNode("jcr:content").getNode("metadata");
                            metaData.setProperty("dam:sha1", sha1);
                        }
                        orgRendContNode.setProperty("jcr:lastModifiedBy", userId);
                        content.setProperty("jcr:lastModifiedBy", userId);
                        break block26;
                    }
                    log.info("XMP Writeback is not supported for type {} using implementation {} for the asset located at {}", mime, this.xmpHandler.getClass().getName(), asset.getPath());
                }
                catch (Throwable e) {
                    log.error(e.getMessage());
                    log.debug("Stack Trace", e);
                    try {
                        if (session.hasPendingChanges()) {
                            session.refresh(false);
                        }
                    }
                    catch (RepositoryException re) {
                        log.error("Failed to refresh workflow session", re);
                    }
                }
            } else {
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot writeback xmp, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWritebackSupported(Asset asset) {
        String mimeType = asset.getMimeType();
        if (EPS_MIMETYPE.equals(mimeType)) {
            PushbackInputStream pin = null;
            try {
                pin = new PushbackInputStream(asset.getOriginal().getStream(), 1024);
                byte[] data = new byte[1024];
                int len = pin.read(data);
                if (len <= 0) {
                    boolean bl = false;
                    return bl;
                }
                pin.unread(data, 0, len);
                if (!this.isIllustratorPDFFile(data, 0, len)) {
                    double adobeMarker = this.getAdobeMarkerFromEPS(data, len);
                    if (adobeMarker > 3.0) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.warn("error while reading AI/EPS file:  [{}]: ", e);
            }
            finally {
                if (pin != null) {
                    try {
                        pin.close();
                    }
                    catch (IOException e) {
                        log.warn("error while closing AI/EPS file input stream:  [{}]: ", e);
                    }
                }
            }
        }
        return true;
    }

    private double getAdobeMarkerFromEPS(byte[] data, int len) {
        double adobeMarker = 0.0;
        int off = this.locate(PS_START, data, 0, len);
        if (off == -1) {
            return adobeMarker;
        }
        if ((off = this.locate(PS_ADOBE, data, off, len)) == -1) {
            return adobeMarker;
        }
        int epsTypeLocation = this.locate(EPS_TYPE, data, off, len);
        if (epsTypeLocation == -1) {
            return adobeMarker;
        }
        String adobeMarkerString = new String(data, off, epsTypeLocation - off);
        try {
            adobeMarker = new Double(adobeMarkerString.replace(new String(EPS_TYPE), "").trim());
        }
        catch (NumberFormatException ne) {
            log.warn("Exception occured while reading PS_ADOBE marker from eps file: " + ne.getMessage());
        }
        return adobeMarker;
    }

    private boolean isIllustratorPDFFile(byte[] data, int off, int len) {
        byte[] pdfMarker = new byte[]{37, 80, 68, 70, 45};
        int size = 1024;
        if (size > len) {
            size = len;
        }
        byte[] header = new byte[size];
        System.arraycopy(data, off, header, 0, size);
        long result = Utility.KMPFindFirst(pdfMarker, Utility.ComputeKMPNextArray(pdfMarker), header);
        return result >= 0L;
    }

    private int locate(byte[] pattern, byte[] data, int off, int len) {
        int i = 0;
        while (i < pattern.length && off < len) {
            i = pattern[i] == data[off] ? ++i : 0;
            ++off;
        }
        return i == pattern.length ? off : -1;
    }

    private void writeXmp(Asset asset, WorkItem workItem, WorkflowSession workflowSession, XMPWriteBackOptions writeBackOptions) {
        Session session = workflowSession.getSession();
        try {
            ExtractedMetadata origdata;
            AssetHandler handler;
            Node assetNode = asset.adaptTo(Node.class);
            Node content = assetNode.getNode("jcr:content");
            XMPMetadata metadata = asset.adaptTo(Resource.class).adaptTo(com.adobe.granite.asset.api.Asset.class).getAssetMetadata().getXMP();
            if (metadata.get("http://ns.adobe.com/exif/1.0/aux/", PS_AUX_ISO) != null) {
                metadata.setSimple("http://ns.adobe.com/exif/1.0/aux/", PS_AUX_ISO, "");
            }
            if (metadata.get("http://ns.adobe.com/exif/1.0/", EXIF_FLASH) != null) {
                metadata.remove("http://ns.adobe.com/exif/1.0/", EXIF_FLASH);
            }
            if (this.xmpFilter != null && this.xmpFilter.isActive() && null != (handler = this.getAssetHandler(asset.getMimeType())) && null != (origdata = handler.extractMetadata(asset)).getXmp()) {
                RDFXMLParser parser = new RDFXMLParser();
                RDFXMLParserContext pctx = new RDFXMLParserContext();
                XMPMetadata originalMeta = parser.parse(this.xmpFilter.sieve(origdata.getXmp()), (Map<String, Object>)pctx);
                if (log.isDebugEnabled()) {
                    log.debug("metadata ignored by ingestion: " + originalMeta.dump());
                }
                this.mergeMeta(metadata, originalMeta);
            }
            String userId = (String)((Object)workItem.getWorkflowData().getMetaDataMap().get("userId", String.class));
            writeBackOptions.setVersionCreator(userId);
            this.xmpHandler.writeXmpMetadata(asset, metadata, writeBackOptions);
        }
        catch (Throwable e) {
            log.warn("XMP Writeback is not supported on this platform or required libraries are missing !!!");
            log.debug("Stack Trace", e);
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException re) {
                log.error("Failed to refresh workflow session", re);
            }
        }
    }

    synchronized void bindXmpHandler(XMPHandler handler) {
        this.xmpHandler = handler;
        log.debug("binding xmp handler");
    }

    synchronized void unbindXmpHandler(XMPHandler handler) {
        this.xmpHandler = null;
        log.debug("un-binding xmp handler");
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String[] renditions;
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String createVersion = (String)((Object)metaData.get(Arguments.CREATE_VERSION.name(), String.class));
        if (StringUtils.isNotBlank(createVersion)) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.CREATE_VERSION.getArgumentPrefix()).append(createVersion);
            arguments.add(builder.toString());
        }
        if ((renditions = (String[])metaData.get(Arguments.RENDITION.name(), String[].class)) != null) {
            for (String rendition : renditions) {
                StringBuilder builder = new StringBuilder();
                builder.append(Arguments.RENDITION.getArgumentPrefix()).append(rendition);
                arguments.add(builder.toString());
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private void mergeMeta(XMPMetadata to, XMPMetadata from) throws XMPException {
        for (XMPNode n : from) {
            XMPNode dest = to.remove(n.getNamespace(), n.getName());
            if (log.isDebugEnabled()) {
                log.debug("merge Node " + n);
                if (dest != null) {
                    log.debug("property {" + dest.getNamespace() + "}" + dest.getName() + " is overwritten");
                }
            }
            if (n instanceof XMPSimple) {
                to.copy((XMPSimple)n);
                continue;
            }
            if (n instanceof XMPStruct) {
                to.copy((XMPStruct)n);
                continue;
            }
            if (!(n instanceof XMPArray)) continue;
            to.copy((XMPArray)n);
        }
    }

    protected void bindXmpFilter(XmpFilter xmpFilter) {
        this.xmpFilter = xmpFilter;
    }

    protected void unbindXmpFilter(XmpFilter xmpFilter) {
        if (this.xmpFilter == xmpFilter) {
            this.xmpFilter = null;
        }
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        CREATE_VERSION("createversion"),
        RENDITION("rendition");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

