/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.keynote;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.standard.keynote.KeynotePresentation;
import com.day.cq.dam.handler.standard.keynote.KeynoteSlide;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Deprecated
@Component(inherit=true, metatype=false)
@Service
public class KeynoteHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(KeynoteHandler.class);
    public static final String[] CONTENT_MIMETYPES = new String[]{"application/x-iWork-keynote-sffkey", "application/x-iwork-keynote-sffkey", "application/vnd.apple.keynote"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        log.debug("extractMetadata: importing asset [{}]", (Object)asset.getPath());
        InputStream is = asset.getOriginal().getStream();
        try {
            KeynotePresentation preso = new KeynotePresentation(is);
            metadata.setMetaDataProperty("tiff:ImageLength", preso.getHeight());
            metadata.setMetaDataProperty("tiff:ImageWidth", preso.getWidth());
            metadata.setMetaDataProperty("Slide Count", preso.getSlides().size());
        }
        catch (SAXException e) {
            log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        catch (IOException e) {
            log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        catch (ParserConfigurationException e) {
            log.warn("extractMetadata: error while extracting metadata from Keynote [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets;
        block8: {
            subAssets = new ArrayList<String>();
            if (asset.isSubAsset()) {
                return subAssets;
            }
            InputStream is = asset.getOriginal().getStream();
            InputStream isp = null;
            ByteArrayOutputStream out = null;
            ByteArrayInputStream ois = null;
            try {
                KeynotePresentation preso = new KeynotePresentation(is);
                List<KeynoteSlide> slides = preso.getSlides();
                boolean oldBatchMode = asset.isBatchMode();
                asset.setBatchMode(true);
                int i = 0;
                for (KeynoteSlide slide : slides) {
                    if (slide.isHidden()) continue;
                    ++i;
                    isp = asset.getOriginal().getStream();
                    KeynotePresentation p = new KeynotePresentation(isp);
                    List<KeynoteSlide> pslides = p.getSlides();
                    for (KeynoteSlide s : pslides) {
                        if (slide.getId().equals(s.getId())) continue;
                        p.removeSlide(s);
                    }
                    out = new ByteArrayOutputStream();
                    p.save(out);
                    ois = new ByteArrayInputStream(out.toByteArray());
                    String fileName = "page" + (i + 1) + ".key";
                    Asset subAsset = asset.addSubAsset(fileName, CONTENT_MIMETYPES[0], ois);
                    subAssets.add(subAsset.getPath());
                }
                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
                IOUtils.closeQuietly(is);
            }
            catch (Exception e) {
                log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                break block8;
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(isp);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(ois);
            }
            IOUtils.closeQuietly(isp);
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(ois);
        }
        return subAssets;
    }

    @Override
    public String[] getMimeTypes() {
        return CONTENT_MIMETYPES;
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        block10: {
            InputStream is = rendition.getStream();
            try {
                BufferedImage bufferedImage;
                KeynotePresentation preso = new KeynotePresentation(is);
                FileOutputStream itout = null;
                FileInputStream iis = null;
                File imageTmpFile = null;
                try {
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    Layer layer = new Layer(preso.getThumbnail());
                    itout = FileUtils.openOutputStream(imageTmpFile);
                    layer.write("image/png", 1.0, itout);
                    iis = FileUtils.openInputStream(imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, dim).getImage();
                }
                catch (Exception e) {
                    try {
                        try {
                            log.info("getImage: cannot extract image for file [{}]: ", (Object)rendition.getPath(), (Object)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(iis);
                            IOUtils.closeQuietly(itout);
                            FileUtils.deleteQuietly(imageTmpFile);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly(itout);
                        FileUtils.deleteQuietly(imageTmpFile);
                        break block10;
                    }
                    catch (Exception e2) {
                        log.warn("getImage: error while creating image from Keynote [{}]: ", (Object)rendition.getPath(), (Object)e2);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(iis);
                IOUtils.closeQuietly(itout);
                FileUtils.deleteQuietly(imageTmpFile);
                return bufferedImage;
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return null;
    }
}

