/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.msoffice;

import com.day.cq.dam.handler.standard.msoffice.IdToNameMap;
import com.day.cq.dam.handler.standard.msoffice.MSOfficeHandler;
import com.day.cq.dam.handler.standard.msoffice.MSOfficeMetadata;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MetaDataReaderListener
implements POIFSReaderListener {
    private static final Logger log = LoggerFactory.getLogger(MSOfficeHandler.class);
    private boolean[] xmlNameStartChars;
    private boolean[] xmlNameChars;
    private MSOfficeMetadata metadata;
    private boolean debug;

    public MetaDataReaderListener() {
        if (log.isDebugEnabled()) {
            this.debug = true;
        }
        this.initCharTables();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        PropertySet ps;
        try {
            ps = PropertySetFactory.create(event.getStream());
        }
        catch (NoPropertySetStreamException e) {
            log.warn("Failed to read metadata: {}", (Object)e.getMessage());
            if (!this.debug) return;
            log.debug("Failed to read metadata", e);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ps.isDocumentSummaryInformation()) {
            DocumentSummaryInformation info = (DocumentSummaryInformation)ps;
            for (Property prop : info.getProperties()) {
                if (this.debug) {
                    log.debug("Setting document metadata property {} = {}", (Object)IdToNameMap.getDocumentPropertyName(prop.getID()), prop.getValue());
                }
                if (!this.isXMLName(IdToNameMap.getDocumentPropertyName(prop.getID()))) continue;
                this.metadata.setProperty(IdToNameMap.getDocumentPropertyName(prop.getID()), prop.getValue(), prop.getType());
            }
            if (null == info.getCustomProperties()) return;
            for (Object e : info.getCustomProperties().values()) {
                CustomProperty prop = (CustomProperty)e;
                if (this.debug) {
                    log.debug("Setting custom metadata property {} = {}", (Object)prop.getName(), prop.getValue());
                }
                this.metadata.setProperty(prop.getName(), prop.getValue(), prop.getType());
            }
            return;
        } else {
            if (!ps.isSummaryInformation()) return;
            try {
                SummaryInformation info = (SummaryInformation)ps;
                for (Property prop : info.getProperties()) {
                    if (this.debug) {
                        log.debug("Setting summary metadata property {} = {}", (Object)IdToNameMap.getSummaryPropertyName(prop.getID()), prop.getValue());
                    }
                    if (!this.isXMLName(IdToNameMap.getSummaryPropertyName(prop.getID()))) continue;
                    this.metadata.setProperty(IdToNameMap.getSummaryPropertyName(prop.getID()), prop.getValue(), prop.getType());
                }
                byte[] picture = info.getThumbnail();
                if (picture == null) return;
                this.metadata.setProperty("picture", picture);
                return;
            }
            catch (Exception e) {
                log.warn("Unable to get SummaryInformation: " + e.getMessage());
            }
        }
    }

    public void setMetadata(MSOfficeMetadata metadata) {
        this.metadata = metadata;
    }

    private boolean isXMLName(String name) {
        if (name.length() > 0 && !this.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (this.isNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNameStartChar(char ch) {
        return ch <= '\u00ff' && this.xmlNameStartChars[ch] || ch >= '\u0100' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\ueffff';
    }

    private boolean isNameChar(char ch) {
        return ch <= '\u00ff' && this.xmlNameChars[ch] || this.isNameStartChar(ch) || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u203f' && ch <= '\u2040';
    }

    private void initCharTables() {
        this.xmlNameChars = new boolean[256];
        this.xmlNameStartChars = new boolean[256];
        for (int ch = 0; ch < this.xmlNameChars.length; ch = (int)((char)(ch + 1))) {
            this.xmlNameStartChars[ch] = ch == 58 || 65 <= ch && ch <= 90 || ch == 95 || 97 <= ch && ch <= 122 || 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 255;
            this.xmlNameChars[ch] = this.xmlNameStartChars[ch] || ch == 45 || ch == 46 || 48 <= ch && ch <= 57 || ch == 183;
        }
    }
}

