/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.pict;

import ch.epfl.lse.jqd.awt.QDCanvas;
import ch.epfl.lse.jqd.basics.QDException;
import ch.epfl.lse.jqd.basics.QDPicture;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.standard.helper.imageinfo.ImageInfo;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(inherit=true, metatype=false)
@Service
public class PictHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PictHandler.class);
    private static final String[] MIME_TYPES = new String[]{"image/pict", "image/x-pict"};
    private static final int VERSION_NUMBER_2 = 767;
    private static final int VERSION_OPERATOR_2 = 17;

    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        log.debug("extractMetadata: importing asset [{}]...", (Object)asset.getPath());
        InputStream is = asset.getOriginal().getStream();
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setDetermineImageNumber(true);
        imageInfo.setInput(is);
        imageInfo.setDetermineImageNumber(true);
        imageInfo.setCollectComments(true);
        if (imageInfo.check()) {
            metadata.setMetaDataProperty("format", imageInfo.getFormatName());
            metadata.setMetaDataProperty("MIME type", imageInfo.getMimeType());
            metadata.setMetaDataProperty("Image Width", imageInfo.getWidth());
            metadata.setMetaDataProperty("Image Height", imageInfo.getHeight());
            metadata.setMetaDataProperty("Bits per pixel", imageInfo.getBitsPerPixel());
            metadata.setMetaDataProperty("Progressive", imageInfo.isProgressive() ? "yes" : "no");
            metadata.setMetaDataProperty("Number of images", imageInfo.getNumberOfImages());
            metadata.setMetaDataProperty("Physical width (dpi)", imageInfo.getPhysicalWidthDpi());
            metadata.setMetaDataProperty("Physical height (dpi)", imageInfo.getPhysicalHeightDpi());
            metadata.setMetaDataProperty("Physical width (inches)", Float.toString(imageInfo.getPhysicalWidthInch()));
            metadata.setMetaDataProperty("Physical height (inches)", Float.toString(imageInfo.getPhysicalHeightInch()));
            int numComments = imageInfo.getNumberOfComments();
            metadata.setMetaDataProperty("Number of textual comments", numComments);
            if (numComments > 0) {
                String comments = "";
                for (int i = 0; i < numComments; ++i) {
                    comments = comments + imageInfo.getComment(i) + "\n";
                }
                metadata.setMetaDataProperty("Comments", comments);
            }
        } else {
            byte[] imageBytes = new byte[552];
            try {
                is.read(imageBytes, 0, 551);
            }
            catch (IOException e) {
                log.debug("reading PICT image header failed");
            }
            int versionOperator = this.convertToShort(imageBytes[520], imageBytes[521]);
            int versionNumber = this.convertToShort(imageBytes[522], imageBytes[523]);
            double defaultDpi = 72.0;
            double imageXRatio = 1.0;
            double imageYRatio = 1.0;
            int imageTopLeftXCordinate = this.convertToShort(imageBytes[512], imageBytes[513]);
            int imageTopLeftYCordinate = this.convertToShort(imageBytes[514], imageBytes[515]);
            int imageBottomRightXCordinate = this.convertToShort(imageBytes[516], imageBytes[517]);
            int imageBottomRightYCordinate = this.convertToShort(imageBytes[518], imageBytes[519]);
            if (versionOperator == 17 && versionNumber == 767) {
                int horizontalResolution = this.convertToShort(imageBytes[530], imageBytes[531]);
                int verticalResolution = this.convertToShort(imageBytes[534], imageBytes[535]);
                imageXRatio = (double)horizontalResolution / defaultDpi;
                imageYRatio = (double)verticalResolution / defaultDpi;
            }
            long imageWidth = imageBottomRightYCordinate - imageTopLeftYCordinate;
            long imageLength = imageBottomRightXCordinate - imageTopLeftXCordinate;
            imageWidth = Math.round((double)imageWidth * imageXRatio);
            imageLength = Math.round((double)imageLength * imageYRatio);
            if (imageWidth > 0L && imageLength > 0L) {
                metadata.setMetaDataProperty("Image Width", imageWidth);
                metadata.setMetaDataProperty("Image Length", imageLength);
            }
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        block12: {
            BufferedImage bufferedImage;
            InputStream is = rendition.getStream();
            File tmpFile = null;
            FileOutputStream out = null;
            try {
                tmpFile = File.createTempFile("pictin", ".pct");
                out = new FileOutputStream(tmpFile);
                try {
                    IOUtils.copy(is, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly(out);
                }
                QDPicture pict = new QDPicture(tmpFile);
                QDCanvas canvas = new QDCanvas(pict);
                Rectangle r = canvas.getBounds();
                BufferedImage image = new BufferedImage(r.width, r.height, 2);
                canvas.paint((Graphics)image.createGraphics());
                bufferedImage = image;
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly(is);
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("getImage: error while creating an image from PICT [{}]: ", (Object)rendition.getPath(), (Object)e);
                    break block12;
                }
                catch (QDException e) {
                    log.warn("getImage: error while creating an image from PICT [{}]: ", (Object)rendition.getPath(), (Object)e);
                }
            }
            IOUtils.closeQuietly(is);
            if (tmpFile != null) {
                tmpFile.delete();
            }
            return bufferedImage;
        }
        return null;
    }

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    private int convertToShort(int byte1, int byte2) {
        return (byte1 & 0xFF) << 8 | byte2 & 0xFF;
    }
}

