/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.zip;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(inherit=true, metatype=false)
@Service
public class ZipHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(ZipHandler.class);
    public static final String JAR_MIME_TYPE = "application/java-archive";
    public static final String ZIP_MIME_TYPE = "application/zip";
    public static final String[] MIME_TYPES = new String[]{"application/java-archive", "application/zip"};
    private static final Pattern pattern = Pattern.compile("^thumbnail\\.(gif|jpg|jpeg|png)$", 2);

    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        try {
            return this._extractMetadata(asset);
        }
        catch (Throwable t) {
            log.info("Failed to extract metadata from asset {}. Trying to write and process it as temp file.", new Object[]{asset.getPath()});
            return this.extractMetadataFromTempFile(asset);
        }
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        ExtractedMetadata metadata = this.extractMetadata(rendition.getAsset());
        BufferedImage thumbnail = (BufferedImage)metadata.getMetaDataProperty("Thumbnail");
        return thumbnail != null ? thumbnail : this.getZipIcon();
    }

    private BufferedImage getZipIcon() throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/day/cq/dam/media/handler/zip/document_zip.png");
        return ImageIO.read(stream);
    }

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    private ExtractedMetadata _extractMetadata(Asset asset) throws IOException {
        ExtractedMetadata metadata = new ExtractedMetadata();
        log.debug("extractMetadata: start extracting asset [{}]", (Object)asset.getPath());
        InputStream is = asset.getOriginal().getStream();
        ZipInputStream zis = new ZipInputStream(is, Charset.forName("Cp437"));
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    buffer.append(entry.getName()).append('\n');
                    ++count;
                }
                this.processZipEntry(entry, metadata, zis);
                zis.closeEntry();
            }
            metadata.setMetaDataProperty("Content", buffer.toString());
            metadata.setMetaDataProperty("File Count", count);
        }
        catch (IOException e) {
            log.warn("extractMetadata: error while reading ZIP archive [{}]: ", (Object)asset.getPath(), (Object)e);
            throw e;
        }
        catch (IllegalArgumentException iae) {
            log.warn("extractMetadata: error while reading ZIP entry [{}]: ", (Object)asset.getPath(), (Object)iae);
            throw iae;
        }
        finally {
            IOUtils.closeQuietly(zis);
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtractedMetadata extractMetadataFromTempFile(Asset asset) {
        ExtractedMetadata metadata;
        block8: {
            metadata = new ExtractedMetadata();
            InputStream is = asset.getOriginal().getStream();
            File tempFile = null;
            ZipFile zf = null;
            try {
                tempFile = this.createTempZipFile(asset);
                tempFile.deleteOnExit();
                IOUtils.copy(is, (OutputStream)new FileOutputStream(tempFile));
                StringBuffer buffer = new StringBuffer();
                int count = 0;
                zf = new ZipFile(tempFile);
                Enumeration<ZipArchiveEntry> entries = zf.getEntries();
                while (entries.hasMoreElements()) {
                    ZipArchiveEntry entry = entries.nextElement();
                    if (!entry.isDirectory()) {
                        buffer.append(entry.getName()).append('\n');
                        ++count;
                    }
                    this.processZipEntry(entry, metadata, zf.getInputStream(entry));
                }
                metadata.setMetaDataProperty("Content", buffer.toString());
                metadata.setMetaDataProperty("File Count", count);
                if (tempFile == null || !tempFile.exists()) break block8;
            }
            catch (IOException e) {
                log.warn("extractMetadata (Apache Commons): error while reading ZIP archive [{}]: ", (Object)asset.getPath(), (Object)e);
                break block8;
            }
            ZipFile.closeQuietly(zf);
            tempFile.delete();
            break block8;
            finally {
                if (tempFile != null && tempFile.exists()) {
                    ZipFile.closeQuietly(zf);
                    tempFile.delete();
                }
            }
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    private File createTempZipFile(Asset asset) throws IOException {
        String name = "ZipHandler_tmp_" + System.currentTimeMillis();
        File tempFile = File.createTempFile(name, ".zip");
        this.writeToFile(tempFile, asset.getOriginal().getStream());
        log.debug("Temp file {} created.", new Object[]{tempFile.getAbsolutePath()});
        return tempFile;
    }

    private void writeToFile(File file, InputStream in) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy(in, (OutputStream)out);
    }

    private void processZipEntry(ZipEntry entry, ExtractedMetadata metadata, InputStream input) {
        Matcher matcher = pattern.matcher(entry.getName());
        if (matcher.find()) {
            try {
                metadata.setMetaDataProperty("Thumbnail", ImageIO.read(input));
            }
            catch (Exception e) {
                log.debug("Error reading zip thumbnail file {}", (Object)entry.getName());
            }
        }
    }
}

