/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.word.process;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service(value={WorkflowProcess.class})
@Properties(value={@Property(name="service.description", value={"Extracts plain text from a Word document and adds it as a rendition."}), @Property(name="service.vendor", value={"Adobe"}), @Property(name="process.label", value={"Extract Plain Text From Word"})})
public class ExtractPlainProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ExtractPlainProcess.class);
    private static final String JCR_PATH = "JCR_PATH";
    @Reference
    ResourceResolverFactory resourceResolverFactory;

    @Override
    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
        try {
            String doc;
            Session jcrSession = session.adaptTo(Session.class);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user.jcr.session", jcrSession);
            ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(params);
            Asset asset = this.getPayloadAsset(item, resourceResolver);
            String assetMime = asset.getMimeType();
            if (assetMime.matches("application.*msword")) {
                doc = this.extractFromDoc(asset);
            } else if (assetMime.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                doc = this.extractFromDocx(asset);
            } else {
                String msg = "No appropriate extractor found for: " + asset.getName();
                throw new IOException(msg);
            }
            if (doc == null || doc.isEmpty()) {
                return;
            }
            Rendition rendition = asset.addRendition("plain", (InputStream)new ByteArrayInputStream(doc.getBytes("UTF-8")), "text/plain");
            Resource resource = rendition.getChild("jcr:content");
            ModifiableValueMap contentProps = resource.adaptTo(ModifiableValueMap.class);
            contentProps.put("jcr:encoding", "UTF-8");
            ResourceResolver resResolver = resource.getResourceResolver();
            resResolver.commit();
        }
        catch (IOException ex) {
            log.error("Could not generate plain text rendition: " + ex);
        }
        catch (LoginException ex) {
            log.error("Could not generate plain text rendition: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractFromDoc(Asset asset) throws IOException {
        String result = "";
        InputStream is = null;
        try {
            Paragraph[] paragraphs;
            is = asset.getOriginal().getStream();
            HWPFDocument doc = new HWPFDocument(is);
            for (Paragraph paragraph : paragraphs = this.getParagraphs(doc.getRange())) {
                result = result + paragraph.text() + "\n\n";
            }
        }
        catch (Exception e) {
            log.error("Error while extracting plain text from doc : " + asset.getPath());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractFromDocx(Asset asset) throws IOException {
        String result = "";
        InputStream is = null;
        try {
            is = asset.getOriginal().getStream();
            XWPFDocument doc = new XWPFDocument(is);
            Iterator<XWPFParagraph> paraIter = doc.getParagraphsIterator();
            while (paraIter.hasNext()) {
                result = result + paraIter.next().getText() + "\n\n";
            }
        }
        catch (Exception e) {
            log.error("Error while extracting plain text from docx : " + asset.getPath());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return result;
    }

    private Asset getPayloadAsset(WorkItem item, ResourceResolver resourceResolver) {
        Asset asset = null;
        if (item.getWorkflowData().getPayloadType().equals(JCR_PATH)) {
            Resource resource;
            String path = item.getWorkflowData().getPayload().toString();
            if (resourceResolver != null && null != (resource = resourceResolver.getResource(path))) {
                asset = DamUtil.resolveToAsset(resource);
            }
        }
        return asset;
    }

    private Paragraph[] getParagraphs(Range range) {
        Paragraph[] paragraphs = new Paragraph[range.numParagraphs()];
        for (int i = 0; i < paragraphs.length; ++i) {
            paragraphs[i] = range.getParagraph(i);
        }
        return paragraphs;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

