/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.core;

import com.day.cq.mcm.core.NewsletterEmulatorGroup;
import com.day.cq.wcm.emulator.Emulator;
import com.day.cq.wcm.emulator.EmulatorGroup;
import com.day.cq.wcm.emulator.EmulatorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

@Component(metatype=false)
@Service
public class NewsletterEmulatorProvider
implements EmulatorProvider {
    private static final String GROUP_PATH = "/libs/mcm/components/newsletter/emailclient";
    private static final String NEWSLETTER_RESOURCE_TYPE = "mcm/components/newsletter/page";
    private static final String SIGHTLY_NEWSLETTER_RESOURCE_TYPE = "mcm/campaign/components/campaign_newsletterpage";
    private static final String BASE_NAME = "base";

    @Override
    public List<Emulator> getEmulators(Resource resource) {
        ResourceResolver rr = resource.getResourceResolver();
        ArrayList<Emulator> emulators = new ArrayList<Emulator>();
        Iterator<Resource> children = rr.listChildren(rr.getResource(GROUP_PATH));
        while (children.hasNext()) {
            Resource child = children.next();
            if (BASE_NAME.equals(ResourceUtil.getName(child))) continue;
            emulators.add(child.adaptTo(Emulator.class));
        }
        return emulators;
    }

    @Override
    public boolean handles(Resource resource) {
        Resource content = !resource.getPath().endsWith("jcr:content") ? resource.getResourceResolver().getResource(resource, "jcr:content") : resource;
        return ResourceUtil.isA(content, NEWSLETTER_RESOURCE_TYPE) || ResourceUtil.isA(content, SIGHTLY_NEWSLETTER_RESOURCE_TYPE);
    }

    @Override
    public List<EmulatorGroup> getEmulatorGroups(Resource resource) {
        ArrayList<EmulatorGroup> groups = new ArrayList<EmulatorGroup>();
        Resource groupRes = resource.getResourceResolver().getResource(GROUP_PATH);
        NewsletterEmulatorGroup group = new NewsletterEmulatorGroup(groupRes);
        group.setEmulators(this.getEmulators(resource));
        groups.add(group);
        return groups;
    }
}

