/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.reporting;

import com.day.cq.reporting.AggregateManager;
import com.day.cq.reporting.Column;
import com.day.cq.reporting.ComponentProvider;
import com.day.cq.reporting.PathResolvingCache;
import com.day.cq.reporting.Sorting;
import com.day.cq.search.QueryBuilder;
import java.util.ResourceBundle;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;

public class Context {
    private final SlingRepository repository;
    private final QueryBuilder queryBuilder;
    private final ComponentProvider componentService;
    private final ResourceBundle resourceBundle;
    private final PathResolvingCache cache;
    private final AggregateManager aggregateManager;
    private final Session reportSession;
    private String reportUserId;
    private Column overriddenSortColumn;
    private Sorting.Direction overriddenSortDir;

    public Context(SlingRepository repository, QueryBuilder queryBuilder, ComponentProvider componentService, ResourceBundle resourceBundle, PathResolvingCache cache, Session reportSession) {
        this(repository, queryBuilder, componentService, resourceBundle, cache, reportSession, null, null);
    }

    public Context(SlingRepository repository, QueryBuilder queryBuilder, ComponentProvider componentService, ResourceBundle resourceBundle, PathResolvingCache cache, String reportUserId) {
        this(repository, queryBuilder, componentService, resourceBundle, cache, null, reportUserId, null);
    }

    protected Context(SlingRepository repository, QueryBuilder queryBuilder, ComponentProvider componentService, ResourceBundle resourceBundle, PathResolvingCache cache, Session reportSession, String reportUserId, AggregateManager aggregateManager) {
        this.repository = repository;
        this.queryBuilder = queryBuilder;
        this.componentService = componentService;
        this.resourceBundle = resourceBundle;
        this.cache = cache;
        this.aggregateManager = aggregateManager == null ? new AggregateManager(this) : aggregateManager;
        this.reportSession = reportSession;
        this.reportUserId = reportUserId;
        this.overriddenSortColumn = null;
        this.overriddenSortDir = null;
    }

    public SlingRepository getRepository() {
        return this.repository;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public ComponentProvider getComponentService() {
        return this.componentService;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public PathResolvingCache getCache() {
        return this.cache;
    }

    public AggregateManager getAggregateManager() {
        return this.aggregateManager;
    }

    public Session getReportSession() {
        return this.reportSession;
    }

    public String getReportUserId() {
        return this.reportUserId;
    }

    public Column getOverriddenSortColumn() {
        return this.overriddenSortColumn;
    }

    public void setOverriddenSortColumn(Column overriddenSortColumn) {
        this.overriddenSortColumn = overriddenSortColumn;
    }

    public Sorting.Direction getOverriddenSortDir() {
        return this.overriddenSortDir;
    }

    public void setOverriddenSortDir(Sorting.Direction overriddenSortDir) {
        this.overriddenSortDir = overriddenSortDir;
    }
}

