/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.form;

import com.day.cq.searchpromote.SearchPromoteException;
import com.day.cq.searchpromote.xml.DOMParser;
import com.day.cq.searchpromote.xml.form.AutoComplete;
import com.day.cq.searchpromote.xml.form.Form;
import com.day.cq.searchpromote.xml.form.Input;
import com.day.cq.searchpromote.xml.form.SearchForm;
import com.day.cq.searchpromote.xml.form.Tnt;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public class SearchFormParser
extends DOMParser {
    private static final String AUTOCOMPLETE_ELEMENT = "autocomplete";
    private static final String TNT_ELEMENT = "tnt";
    private static final String FORM_ELEMENT = "form";
    private static final String CSS_ELEMENT = "css";
    private static final String ENABLED_ELEMENT = "enabled";
    private static final String JAVASCRIPT_ELEMENT = "javascript";
    private static final String FORMCONTENT_ELEMENT = "form-content";
    private static final String NAME_ELEMENT = "name";
    private static final String ID_ELEMENT = "id";
    private static final String ACTION_ELEMENT = "action";
    private static final String TYPE_ELEMENT = "type";
    private static final String VALUE_ELEMENT = "value";
    private static final String INPUTS_ELEMENT = "inputs";

    public SearchForm parse(InputSource xml) throws SearchPromoteException {
        Element root = this.parseXML(xml);
        Element autocompleteElement = this.getElement(root, AUTOCOMPLETE_ELEMENT, false);
        AutoComplete autocomplete = autocompleteElement != null ? this.parseAutocomplete(autocompleteElement) : null;
        Element tntElement = this.getElement(root, TNT_ELEMENT, false);
        Tnt tnt = tntElement != null ? this.parseTnt(tntElement) : null;
        Element formElement = this.getElement(root, FORM_ELEMENT, true);
        Form form = this.parseForm(formElement);
        return new SearchForm(autocomplete, tnt, form);
    }

    protected AutoComplete parseAutocomplete(Element element) throws SearchPromoteException {
        Boolean isEnabled = this.getEnabled(element);
        String formContent = this.getElement(element, FORMCONTENT_ELEMENT, true).getTextContent();
        String javaScript = this.getElement(element, JAVASCRIPT_ELEMENT, true).getTextContent();
        String css = this.getElement(element, CSS_ELEMENT, true).getTextContent();
        return new AutoComplete(isEnabled, formContent, javaScript, css);
    }

    protected Tnt parseTnt(Element element) throws SearchPromoteException {
        Boolean isEnabled = this.getEnabled(element);
        String formContent = this.getElement(element, FORMCONTENT_ELEMENT, true).getTextContent();
        String javaScript = this.getElement(element, JAVASCRIPT_ELEMENT, true).getTextContent();
        return new Tnt(isEnabled, formContent, javaScript);
    }

    protected Form parseForm(Element element) throws SearchPromoteException {
        String name = this.getElement(element, NAME_ELEMENT, true).getTextContent();
        String id = this.getElement(element, ID_ELEMENT, true).getTextContent();
        String action = this.getElement(element, ACTION_ELEMENT, true).getTextContent();
        Element inputs = this.getElement(element, INPUTS_ELEMENT, false);
        List<Input> input = this.parseInputs(inputs);
        return new Form(name, id, action, input);
    }

    protected List<Input> parseInputs(Element element) throws SearchPromoteException {
        ArrayList<Input> inputs = new ArrayList<Input>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            String type = this.getElement((Element)n, TYPE_ELEMENT, true).getTextContent();
            Element valueEl = this.getElement((Element)n, VALUE_ELEMENT, false);
            String value = valueEl != null ? valueEl.getTextContent() : null;
            Element idEl = this.getElement((Element)n, ID_ELEMENT, false);
            String id = idEl != null ? idEl.getTextContent() : null;
            Element nameEl = this.getElement((Element)n, NAME_ELEMENT, false);
            String name = nameEl != null ? nameEl.getTextContent() : null;
            inputs.add(new Input(type, id, name, value));
        }
        return inputs;
    }

    private Boolean getEnabled(Element element) throws SearchPromoteException {
        String enabled = this.getElement(element, ENABLED_ELEMENT, true).getTextContent();
        Boolean isEnabled = Integer.parseInt(enabled) == 1 ? Boolean.TRUE : Boolean.FALSE;
        return isEnabled;
    }
}

