/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHelper {
    private static final Logger log = LoggerFactory.getLogger(RequestHelper.class);

    public static boolean handleIfModifiedSince(HttpServletRequest req, HttpServletResponse resp, ValueMap properties) {
        Calendar lastMod = (Calendar)((Object)properties.get("jcr:lastModified", Calendar.class));
        if (lastMod == null) {
            lastMod = (Calendar)((Object)properties.get("cq:lastModified", Calendar.class));
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("If-Modified-Since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod.getTimeInMillis());
        }
        return false;
    }

    public static boolean handleIfModifiedSince(HttpServletRequest req, HttpServletResponse resp, Node node) {
        Calendar lastMod = null;
        try {
            Node scan = node;
            while (scan.getDepth() > 0 && lastMod == null) {
                if (scan.hasProperty("jcr:lastModified")) {
                    lastMod = scan.getProperty("jcr:lastModified").getDate();
                    continue;
                }
                if (scan.hasProperty("cq:lastModified")) {
                    lastMod = scan.getProperty("cq:lastModified").getDate();
                    continue;
                }
                scan = scan.getParent();
            }
        }
        catch (AccessDeniedException e) {
            log.debug("Error while searching for last modified property: " + (Object)((Object)e));
        }
        catch (RepositoryException e) {
            log.warn("Error while searching for last modified property: " + (Object)((Object)e));
        }
        try {
            if (lastMod == null && node.hasProperty("jcr:content/jcr:lastModified")) {
                lastMod = node.getProperty("jcr:content/jcr:lastModified").getDate();
            }
        }
        catch (AccessDeniedException e) {
            log.debug("Error while searching for last modified property: " + (Object)((Object)e));
        }
        catch (RepositoryException e) {
            log.warn("Error while searching for last modified property: " + (Object)((Object)e));
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("If-Modified-Since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod.getTimeInMillis());
        }
        return false;
    }
}

