/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.TemplateManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedContainer
extends WCMUsePojo {
    public static final Logger log = LoggerFactory.getLogger(TemplatedContainer.class);
    private Page page;
    private Template template;
    private ComponentContext componentContext;
    private TemplateManager templateManager;

    public TemplatedContainer(TemplateManager templateManager, ComponentContext componentContext) {
        this.componentContext = componentContext;
        if (componentContext == null) {
            throw new IllegalArgumentException("componentContext is null");
        }
        if (templateManager == null) {
            throw new IllegalArgumentException("templateManger is null");
        }
        this.templateManager = templateManager;
        this.page = componentContext.getPage();
        if (this.page == null) {
            throw new IllegalArgumentException("component's page is null");
        }
        this.initTemplate();
    }

    @Override
    public void activate() throws Exception {
        this.componentContext = WCMUtils.getComponentContext((ServletRequest)this.getRequest());
        if (this.componentContext == null) {
            throw new IllegalArgumentException("componentContext is null");
        }
        this.templateManager = this.getResourceResolver().adaptTo(TemplateManager.class);
        if (this.templateManager == null) {
            throw new IllegalArgumentException("templateManger is null");
        }
        this.page = this.getResourcePage();
        if (this.page == null) {
            throw new IllegalArgumentException("component's page is null");
        }
        this.initTemplate();
    }

    public List<Resource> getStructureResources() {
        if (!this.hasStructureSupport()) {
            log.warn("template has no structure support", (Object)this.componentContext.toString());
        }
        return this.templateManager.getStructureResources(this.componentContext);
    }

    public String getNewResourceType() {
        return "wcm/foundation/components/templatedcontainer/newcontainer";
    }

    public boolean hasStructureSupport() {
        return this.template != null && this.template.hasStructureSupport();
    }

    private void initTemplate() {
        this.template = this.page.getTemplate();
        if (this.template == null) {
            PageManager pageManager = this.componentContext.getResource().getResourceResolver().adaptTo(PageManager.class);
            Page containingPage = pageManager.getContainingPage(this.componentContext.getResource());
            if (containingPage != null && containingPage.getTemplate() != null) {
                this.template = containingPage.getTemplate();
            } else {
                log.info("page has no template assigned", (Object)this.componentContext.toString());
            }
        }
    }
}

