/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FormResourceEdit;
import com.day.cq.wcm.foundation.forms.FormsHandlingResponse;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class FieldHelper {
    private static final String SLING_SCRIPTING_USER = "sling-scripting";
    private static final String ATTR_CACHE = FieldHelper.class.getName() + "/Cache";
    private static final String ATTR_INIT = FieldHelper.class.getName() + "/Init";
    private static final String ATTR_DESC = FieldHelper.class.getName() + "/CurrentDesc";

    private FieldHelper() {
    }

    private static String getCacheAttrName(Resource rsrc) {
        return ATTR_CACHE + rsrc.getPath();
    }

    private static String getInitAttrName(Resource rsrc) {
        return ATTR_INIT + rsrc.getPath();
    }

    public static FieldDescription createDefaultDescription(SlingHttpServletRequest req, Resource rsrc) {
        FieldDescription desc = new FieldDescription(rsrc);
        desc.update(rsrc);
        FieldHelper.addDescription(req, desc);
        return desc;
    }

    public static void addDescription(SlingHttpServletRequest req, FieldDescription desc) {
        String key = FieldHelper.getCacheAttrName(desc.getFieldResource());
        FieldDescription[] descs = (FieldDescription[])req.getAttribute(key);
        if (descs == null) {
            descs = new FieldDescription[]{desc};
        } else {
            FieldDescription[] newDescs = new FieldDescription[descs.length + 1];
            System.arraycopy(descs, 0, newDescs, 0, descs.length);
            newDescs[descs.length] = desc;
            descs = newDescs;
        }
        req.setAttribute(key, descs);
    }

    public static FieldDescription[] getFieldDescriptions(SlingHttpServletRequest req, Resource rsrc) {
        String key = FieldHelper.getCacheAttrName(rsrc);
        FieldDescription[] descs = (FieldDescription[])req.getAttribute(key);
        if (descs == null) {
            descs = new FieldDescription[]{FieldHelper.createDefaultDescription(req, rsrc)};
        }
        return descs;
    }

    public static void initializeField(SlingHttpServletRequest req, SlingHttpServletResponse res, Resource rsrc) throws ServletException, IOException {
        FieldHelper.initField(req, res, rsrc);
    }

    public static String getClientFieldQualifier(SlingHttpServletRequest request, FieldDescription desc) {
        return FieldHelper.getClientFieldQualifier(request, desc, "");
    }

    public static String getClientFieldQualifier(SlingHttpServletRequest request, FieldDescription desc, String suffix) {
        String formId = FormsHelper.getFormId(request);
        XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
        return "document.forms[\"" + xssapi.encodeForJSString(formId) + "\"].elements[\"" + xssapi.encodeForJSString(desc.getName() + suffix) + "\"]";
    }

    public static FieldDescription getConstraintFieldDescription(SlingHttpServletRequest req) {
        FieldDescription desc = (FieldDescription)req.getAttribute(ATTR_DESC);
        if (desc == null) {
            desc = new FieldDescription(req.getResource());
            desc.update(req.getResource());
        }
        return desc;
    }

    public static void writeClientRequiredCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException {
        String formId = FormsHelper.getFormId(request);
        if (desc.isRequired()) {
            PrintWriter out = response.getWriter();
            String qualifier = FieldHelper.getClientFieldQualifier(request, desc);
            String requiredMsg = desc.getRequiredMessage();
            requiredMsg = FormsHelper.getLocalizedMessage(requiredMsg, request);
            out.write("if (cq5forms_isEmpty(");
            out.write(qualifier);
            out.write(")) {cq5forms_showMsg('");
            XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
            out.write(xssapi.encodeForJSString(formId));
            out.write("','");
            out.write(xssapi.encodeForJSString(desc.getName()));
            out.write("','");
            out.write(xssapi.encodeForJSString(requiredMsg));
            out.write("'); return false; }\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConstraintMessage(FieldDescription desc, SlingHttpServletRequest request) {
        String msg = desc.getConstraintMessage();
        if (msg == null) {
            try (ResourceResolver resourceResolver = FieldHelper.getScriptResourceResolver();){
                String[] paths = resourceResolver.getSearchPath();
                for (int index = 0; index < paths.length && msg == null; ++index) {
                    String scriptPath = paths[index] + request.getResource().getResourceType();
                    try {
                        Resource scriptResource = resourceResolver.getResource(scriptPath);
                        if (scriptResource == null) continue;
                        ValueMap props = ResourceUtil.getValueMap(scriptResource);
                        msg = (String)((Object)props.get("constraintMessage", String.class));
                        continue;
                    }
                    catch (SlingException slingException) {
                        // empty catch block
                    }
                }
            }
            if (msg == null) {
                msg = "Field is not valid.";
            }
        }
        msg = FormsHelper.getLocalizedMessage(msg, request);
        return msg;
    }

    public static void writeClientRegexpText(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc, String regexp) throws IOException {
        PrintWriter out = response.getWriter();
        String id = FieldHelper.getClientFieldQualifier(request, desc);
        out.write("var obj = ");
        out.write(id);
        out.write(";");
        out.write("if (typeof obj !== 'undefined') { ");
        out.write("if (cq5forms_isArray(obj)) {for(i=0;i<obj.length;i++) {if (!cq5forms_regcheck(obj[i].value, ");
        out.write(regexp);
        out.write(")) {cq5forms_showMsg('");
        out.write(FormsHelper.getFormId(request));
        out.write("','");
        out.write(desc.getName());
        out.write("','");
        out.write(FieldHelper.getConstraintMessage(desc, request));
        out.write("', i); return false;}}");
        out.write("} else {if (!cq5forms_regcheck(obj.value, ");
        out.write(regexp);
        out.write(")) {cq5forms_showMsg('");
        XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
        out.write(xssapi.encodeForJSString(FormsHelper.getFormId(request)));
        out.write("','");
        out.write(xssapi.encodeForJSString(desc.getName()));
        out.write("','");
        out.write(xssapi.encodeForJSString(FieldHelper.getConstraintMessage(desc, request)));
        out.write("'); return false;}}");
        out.write("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientConstraintCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException, ServletException {
        if (desc.getConstraintType() != null) {
            PrintWriter out = response.getWriter();
            String qualifier = FieldHelper.getClientFieldQualifier(request, desc);
            out.write("if (!cq5forms_isEmpty(");
            out.write(qualifier);
            out.write(")){");
            try {
                request.setAttribute(ATTR_DESC, desc);
                ResourceWrapper includeResource = new ResourceWrapper(desc.getFieldResource(), desc.getConstraintType(), "foundation/components/form/defaults/constraint");
                FormsHelper.includeResource(request, response, (Resource)includeResource, "clientvalidation");
                out.write("}");
            }
            finally {
                request.removeAttribute(ATTR_DESC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConstraint(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException, ServletException {
        if (!FieldHelper.isEmpty(request, desc.getName()) && FieldHelper.doValidation(request, desc) && desc.getConstraintType() != null) {
            try {
                request.setAttribute(ATTR_DESC, desc);
                ResourceWrapper includeResource = new ResourceWrapper(desc.getFieldResource(), desc.getConstraintType(), "foundation/components/form/defaults/constraint");
                FormsHelper.includeResource(request, response, (Resource)includeResource, "servervalidation");
            }
            finally {
                request.removeAttribute(ATTR_DESC);
            }
        }
    }

    public static boolean checkRequired(SlingHttpServletRequest request, FieldDescription desc) {
        if (FieldHelper.isRequired(request, desc) && FieldHelper.isEmpty(request, desc.getName()) && FieldHelper.doValidation(request, desc)) {
            ValidationInfo.createValidationInfo(request).addErrorMessage(desc.getName(), desc.getRequiredMessage());
            return false;
        }
        return true;
    }

    private static boolean doValidation(SlingHttpServletRequest request, FieldDescription desc) {
        return request.getParameter(desc.getName() + "@Write") != null || FormResourceEdit.isSingleResourcePost(request);
    }

    private static void initField(SlingHttpServletRequest req, SlingHttpServletResponse res, Resource rsrc) throws ServletException, IOException {
        String key = FieldHelper.getInitAttrName(rsrc);
        Object flag = req.getAttribute(key);
        if (flag == null) {
            req.setAttribute(key, Boolean.TRUE);
            FormsHelper.includeResource(req, new FormsHandlingResponse(res), rsrc, "init");
        }
    }

    private static boolean isEmpty(SlingHttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i].trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isRequired(SlingHttpServletRequest request, FieldDescription desc) {
        String[] abacus_fields = request.getParameterValues(":fieldhidden");
        if (abacus_fields != null) {
            for (int i = 0; i < abacus_fields.length; ++i) {
                if (!abacus_fields[i].trim().equals(desc.getName())) continue;
                return false;
            }
        }
        return desc.isRequired();
    }

    private static ResourceResolver getScriptResourceResolver() {
        BundleContext bundleContext = FrameworkUtil.getBundle(FieldHelper.class).getBundleContext();
        ServiceReference factoryRef = bundleContext.getServiceReference(ResourceResolverFactory.class.getName());
        ResourceResolverFactory resolverFactory = (ResourceResolverFactory)bundleContext.getService(factoryRef);
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("sling.service.subservice", SLING_SCRIPTING_USER);
        try {
            return resolverFactory.getServiceResourceResolver(authenticationInfo);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }
}

