/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.model.responsivegrid;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.foundation.model.impl.export.AllowedComponentsExporter;
import com.day.cq.wcm.foundation.model.responsivegrid.Breakpoint;
import com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveColumn;
import com.day.cq.wcm.foundation.model.responsivegrid.export.ResponsiveGridExporter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ResponsiveGrid.class, ComponentExporter.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL, resourceType={"wcm/foundation/components/responsivegrid"})
@Exporter(name="jackson", selector="model", extensions={"json"})
@JsonSerialize(as=ResponsiveGridExporter.class)
@ProviderType
public class ResponsiveGrid
extends AbstractResource
implements ResponsiveGridExporter {
    protected static final String RESOURCE_TYPE = "wcm/foundation/components/responsivegrid";
    @Self
    private SlingHttpServletRequest slingRequest;
    @SlingObject
    private volatile Resource resource;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @Inject
    private ModelFactory modelFactory;
    private String classNames;
    private Map<String, String> columnClassNames = new HashMap<String, String>();
    private Map<String, ResponsiveColumn> childColumns = new LinkedHashMap<String, ResponsiveColumn>();
    private int columns;

    @PostConstruct
    protected void initModel() {
        HashMap<String, Breakpoint> breakpoints = new HashMap<String, Breakpoint>();
        HashSet missingParagraphBreakpointNames = new HashSet();
        String classNamesPrefix = this.currentStyle.get("cssPrefix", "aem-Grid");
        this.classNames = "aem-Grid";
        Resource responsiveCfg = this.resource.getChild("cq:responsive");
        Resource responsiveParentCfg = null;
        Resource parent = this.resource.getParent();
        if (parent != null) {
            responsiveParentCfg = parent.getChild("cq:responsive");
        }
        boolean hasResponsiveCfgSize = false;
        this.columns = this.currentStyle.get("columns", 12);
        int width = this.currentStyle.get("columns", 0);
        int offset = this.currentStyle.get("offset", 0);
        boolean hasDesignValues = width > 0 || this.currentStyle.containsKey("offset");
        int initialDefaultWidth = 12;
        Object effectiveResource = this.getEffectiveResource();
        Resource effectiveResponsiveConfig = effectiveResource.getChild("cq:responsive/default");
        if (effectiveResponsiveConfig != null && effectiveResponsiveConfig.getValueMap().containsKey("width")) {
            initialDefaultWidth = effectiveResponsiveConfig.getValueMap().get("width", 12);
        }
        if (responsiveCfg != null) {
            Iterator<Resource> resCfgIt = responsiveCfg.listChildren();
            while (resCfgIt.hasNext()) {
                ValueMap parentCfg;
                int parentWidth;
                Resource parentBreakpoint;
                Resource resCfg = resCfgIt.next();
                String breakpointName = resCfg.getName();
                ValueMap cfg = resCfg.adaptTo(ValueMap.class);
                Breakpoint.ResponsiveBehavior behavior = Breakpoint.ResponsiveBehavior.valueOf(cfg.get("behavior", Breakpoint.ResponsiveBehavior.none.toString()));
                if (!hasDesignValues) {
                    int resWidth = cfg.get("width", 0);
                    int resOffset = cfg.get("offset", 0);
                    width = resWidth > 0 ? resWidth : width;
                    int n = offset = resOffset > 0 ? resOffset : offset;
                }
                if (width > 0 && responsiveParentCfg != null && (parentBreakpoint = responsiveParentCfg.getChild(breakpointName)) != null && width + offset > (parentWidth = (parentCfg = parentBreakpoint.adaptTo(ValueMap.class)).get("width", width).intValue())) {
                    width = parentWidth;
                    offset = 0;
                }
                breakpoints.put(breakpointName, new Breakpoint(breakpointName, width, offset, behavior));
                if (width <= 0) continue;
                hasResponsiveCfgSize = true;
                this.classNames = this.classNames + " aem-Grid--" + breakpointName + "--" + width;
            }
        }
        if (!hasResponsiveCfgSize) {
            int columns = this.currentStyle.get("columns", initialDefaultWidth);
            this.classNames = this.classNames + " aem-Grid--" + columns;
        }
        if (!breakpoints.containsKey("default")) {
            int columns = this.currentStyle.get("columns", initialDefaultWidth);
            breakpoints.put("default", new Breakpoint("default", columns, offset, Breakpoint.ResponsiveBehavior.none));
            this.classNames = this.classNames + " aem-Grid--default--" + columns;
        }
        Iterator<Resource> paragraphsIt = this.getEffectiveResource().listChildren();
        while (paragraphsIt.hasNext()) {
            Resource child = paragraphsIt.next();
            if ("cq:responsive".equals(child.getName())) continue;
            ResponsiveColumn column = new ResponsiveColumn(child, breakpoints, classNamesPrefix, this.slingRequest, this.modelFactory);
            this.childColumns.put(column.getResource().getName(), column);
            HashSet<String> columnBreakpointNames = new HashSet<String>();
            Map<String, Breakpoint> columnBreakpoints = column.getBreakpoints();
            this.columnClassNames.put(column.getName(), column.getColumnClassNames());
            if (columnBreakpoints != null) {
                columnBreakpointNames.addAll(columnBreakpoints.keySet());
            }
            columnBreakpointNames.removeAll(breakpoints.keySet());
            missingParagraphBreakpointNames.addAll(columnBreakpointNames);
        }
        if (!missingParagraphBreakpointNames.isEmpty()) {
            for (String missingParagraphBreakpointName : missingParagraphBreakpointNames) {
                Breakpoint missingBreakpoint = (Breakpoint)breakpoints.get("default");
                int missingWidth = missingBreakpoint.getWidth();
                int missingOffset = missingBreakpoint.getOffset();
                Breakpoint.ResponsiveBehavior missingBehavior = missingBreakpoint.getResponsiveBehavior();
                if (missingWidth == 0) {
                    missingWidth = this.currentStyle.get("columns", initialDefaultWidth);
                }
                if (missingWidth > 0) {
                    this.classNames = this.classNames + " aem-Grid--" + missingParagraphBreakpointName + "--" + missingWidth;
                }
                if (missingOffset > 0) {
                    this.classNames = this.classNames + " aem-Grid--offset--" + missingParagraphBreakpointName + "--" + missingOffset;
                }
                breakpoints.put(missingParagraphBreakpointName, new Breakpoint(missingParagraphBreakpointName, missingWidth, missingOffset, missingBehavior));
            }
        }
        this.classNames = this.classNames + " " + this.properties.get("cq:cssClass", "");
        this.classNames = this.classNames.trim();
    }

    @Override
    public String getGridClassNames() {
        return this.classNames;
    }

    @Override
    public Map<String, String> getColumnClassNames() {
        return this.columnClassNames;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Nonnull
    public Collection<? extends ResponsiveColumn> getColumns() {
        return this.childColumns.values();
    }

    public List<ResponsiveColumn> getParagraphs() {
        return new ArrayList<ResponsiveColumn>(this.getColumns());
    }

    public String getCssClass() {
        return this.classNames;
    }

    @Nonnull
    public <T extends Resource> T getEffectiveResource() {
        if (this.resource instanceof TemplatedResource) {
            return (T)this.resource;
        }
        Resource templatedResource = (Resource)this.slingRequest.adaptTo(TemplatedResource.class);
        if (templatedResource == null) {
            return (T)this.resource;
        }
        return (T)templatedResource;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public AllowedComponentsExporter getAllowedComponents() {
        return (AllowedComponentsExporter)this.slingRequest.adaptTo(AllowedComponentsExporter.class);
    }

    @Override
    @Nonnull
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getResourceSuperType() {
        return this.resource.getResourceSuperType();
    }

    @Override
    @Nonnull
    public ResourceMetadata getResourceMetadata() {
        return this.resource.getResourceMetadata();
    }

    @Override
    @Nonnull
    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }

    @Override
    @Nonnull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return this.childColumns;
    }

    @Override
    @Nonnull
    public String[] getExportedItemsOrder() {
        return this.childColumns.isEmpty() ? new String[]{} : this.childColumns.keySet().toArray(new String[this.childColumns.size()]);
    }

    @Override
    @Nonnull
    public String getExportedType() {
        return this.resource.getResourceType();
    }
}

