/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.mobile.core;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.mobile.api.device.DeviceGroup;
import com.day.cq.wcm.mobile.api.device.DeviceGroupList;
import com.day.cq.wcm.mobile.api.device.capability.DeviceCapability;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileUtil {
    private static final Logger log = LoggerFactory.getLogger(MobileUtil.class);

    public static boolean isDeviceGroup(Resource resource) {
        return null != resource && ResourceUtil.isA(resource, "wcm/mobile/components/devicegroup");
    }

    public static boolean isDeviceGroup(Page page) {
        return null != page && MobileUtil.isDeviceGroup(page.getContentResource());
    }

    public static DeviceGroup getDefaultDeviceGroup(Page page) {
        DeviceGroupList mappedDeviceGroups = page.adaptTo(DeviceGroupList.class);
        if (null != mappedDeviceGroups && !mappedDeviceGroups.isEmpty()) {
            return (DeviceGroup)mappedDeviceGroups.get(0);
        }
        return null;
    }

    public static String getDeviceGroupSelector(SlingHttpServletRequest request) {
        String[] selectors = request.getRequestPathInfo().getSelectors();
        return 0 < selectors.length ? selectors[selectors.length - 1] : null;
    }

    public static boolean hasCapability(SlingHttpServletRequest request, DeviceCapability capability) {
        DeviceGroup group = (DeviceGroup)request.adaptTo(DeviceGroup.class);
        return null != group && group.hasCapability(capability);
    }

    public static boolean isMobileRequest(SlingHttpServletRequest r) {
        return StringUtils.contains(r.getHeader("User-Agent"), "Mobile") || StringUtils.contains(r.getHeader("User-Agent"), "Blackberry");
    }

    public static boolean isMobileResource(Resource r) {
        return MobileUtil.isMobileResource(r, null);
    }

    public static boolean isMobileResource(Resource r, String[] types) {
        if (r == null) {
            log.debug("Resource is null, isMobileResource() returns false");
            return false;
        }
        boolean isMobileResource = false;
        PageManager pm = r.getResourceResolver().adaptTo(PageManager.class);
        if (null != pm) {
            Page page = pm.getContainingPage(r);
            if (null != page) {
                while (!isMobileResource && null != page) {
                    Resource content = page.getContentResource();
                    boolean bl = isMobileResource = null != content && ResourceUtil.isA(content, "wcm/mobile/components/page");
                    if (!isMobileResource && null != content && null != types) {
                        for (String type : types) {
                            if (type != null && type.length() > 0) {
                                isMobileResource = ResourceUtil.isA(content, type);
                            }
                            if (isMobileResource) break;
                        }
                    }
                    if (isMobileResource) {
                        log.debug("isMobileResource: resource [{}] is a mobile resource by associated page [{}]", (Object)r.getPath(), (Object)page.getPath());
                    }
                    page = page.getParent();
                }
            } else {
                log.debug("isMobileResource: cannot check resource [{}], not part of a page.", (Object)r.getPath());
            }
        } else {
            log.error("isMobileResource: cannot check resource [{}], page manager unavailable.", (Object)r.getPath());
        }
        if (!isMobileResource) {
            log.debug("isMobileResource: resource [{}] is not a mobile resource.", (Object)r.getPath());
        }
        return isMobileResource;
    }

    public static boolean isPreventRedirect(Resource r) {
        Resource content;
        String path = r.getPath();
        int idx = path.indexOf("/jcr:content");
        if (idx >= 0) {
            path = path.substring(0, idx);
        }
        if ((content = r.getResourceResolver().getResource(path + "/jcr:content")) != null) {
            ValueMap props = content.adaptTo(ValueMap.class);
            return props.get("mobilePreventRedirect", false);
        }
        return false;
    }

    public static boolean isNoMatch(String[] selectors) {
        return selectors != null && selectors.length > 0 && selectors[selectors.length - 1].equals("nomatch");
    }
}

