/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.offline;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.offline.DocImporter;
import com.day.cq.wcm.offline.DocxImporter;
import com.day.cq.wcm.offline.Paragraph;
import com.day.cq.wcm.offline.Picture;
import com.day.cq.wcm.offline.TextDocumentImporter;
import com.day.cq.wcm.offline.TextImportException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OfflineImporter {
    private static final Logger log = LoggerFactory.getLogger(OfflineImporter.class);
    private final Node parent;
    private final TextDocumentImporter importer;
    private String filename;
    private String resourceType;
    private String template;
    private ValueMap config;

    public OfflineImporter(Node parent, InputStream stream) throws IOException, TextImportException {
        this.parent = parent;
        this.importer = new DocImporter(stream);
    }

    public OfflineImporter(Node parent, RequestParameter rp) throws IOException, TextImportException {
        this.parent = parent;
        this.importer = OfflineImporter.getImporter(rp);
    }

    private static TextDocumentImporter getImporter(RequestParameter rp) throws IOException, TextImportException {
        try {
            return new DocImporter(rp.getInputStream());
        }
        catch (TextImportException ex) {
            return new DocxImporter(rp.getInputStream());
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void importDocument() throws RepositoryException {
        String title = this.getTitle(this.filename);
        Node node = this.parent.addNode(this.getNodeName(this.filename), "cq:Page");
        Node content = node.addNode("jcr:content", "cq:PageContent");
        if (this.resourceType != null) {
            content.setProperty("sling:resourceType", this.resourceType);
        }
        if (this.template != null) {
            content.setProperty("cq:template", this.template);
        }
        content.setProperty("jcr:title", title);
        content.setProperty("pageTitle", title);
        Node parsys = content.addNode("par", "nt:unstructured");
        parsys.setProperty("sling:resourceType", "foundation/components/parsys");
        for (int i = 0; i < this.importer.getNumberOfParagraphs(); ++i) {
            Node paragraph = parsys.addNode("par" + i, "nt:unstructured");
            Paragraph p = this.importer.getParagraph(i);
            String html = p.getHTML();
            List<Picture> pics = p.getPictures();
            if (pics.size() == 0) {
                this.importTextParagraph(paragraph, p);
                continue;
            }
            if (html.length() == 0) {
                this.importImageParagraph(paragraph, p);
                continue;
            }
            this.importTextImageParagraph(paragraph, p);
        }
    }

    private void importTextParagraph(Node node, Paragraph paragraph) throws RepositoryException {
        node.setProperty("sling:resourceType", this.config.get("text", "foundation/components/text"));
        node.setProperty("textIsRich", "true");
        node.setProperty("text", paragraph.getHTML());
    }

    private void importTextImageParagraph(Node node, Paragraph paragraph) throws RepositoryException {
        node.setProperty("sling:resourceType", this.config.get("textimage", "foundation/components/textimage"));
        node.setProperty("textIsRich", "true");
        Node image = node.addNode("image", "nt:unstructured");
        this.importImageParagraph(image, paragraph);
        node.setProperty("text", paragraph.getHTML());
    }

    private void importImageParagraph(Node node, Paragraph paragraph) throws RepositoryException {
        List<Picture> pics = paragraph.getPictures();
        if (pics.size() == 0) {
            throw new RepositoryException("Paragraoh does not contain any pictures");
        }
        if (pics.size() > 1) {
            log.debug("paragraph contains multiple pictures, all but last are dropped");
        }
        node.setProperty("sling:resourceType", this.config.get("image", "foundation/components/image"));
        Node file = node.addNode("file", "nt:resource");
        file.setProperty("jcr:lastModified", Calendar.getInstance());
        file.setProperty("jcr:mimeType", pics.get(0).getMediaType());
        file.setProperty("jcr:data", node.getSession().getValueFactory().createBinary((InputStream)new ByteArrayInputStream(pics.get(0).getBytes())));
    }

    private String getTitle(String filename) {
        String title = this.importer.getTitle();
        return title != null ? title : this.trimFilename(filename);
    }

    private String trimFilename(String filename) {
        if (filename.endsWith(".doc")) {
            return filename.substring(0, filename.length() - ".doc".length());
        }
        if (filename.endsWith(".docx")) {
            return filename.substring(0, filename.length() - ".docx".length());
        }
        return filename;
    }

    private String getNodeName(String filename) {
        return JcrUtil.createValidName(this.trimFilename(filename));
    }

    public void setConfig(ValueMap config) {
        this.config = config;
    }
}

