/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.offline;

import com.day.cq.commons.servlets.HtmlStatusResponseHelper;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.offline.OfflineExporter;
import com.day.cq.wcm.offline.OfflineImporter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.paths", value={"/libs/wcm/offline/import"}), @Property(name="sling.servlet.methods", value={"POST", "GET"}), @Property(name="sling.servlet.selectors", value={"offline", "offlinecomponents"}), @Property(name="sling.servlet.extensions", value={"doc", "json"})})
public class OfflineServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -7939838253258809729L;
    private static final Logger log = LoggerFactory.getLogger(OfflineServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        HtmlResponse htmlResponse;
        block11: {
            htmlResponse = null;
            if (request.getParameter("parent") != null) {
                String parentPath = request.getParameter("parent");
                Node node = request.getResourceResolver().getResource(parentPath).adaptTo(Node.class);
                if (node == null) {
                    htmlResponse = HtmlStatusResponseHelper.createStatusResponse(false, "Parent node not found");
                } else if (request.getRequestParameter("document") != null && request.getRequestParameter("document").getInputStream() != null) {
                    try {
                        String templatePath;
                        ValueMap config = this.getConfig(request);
                        String string = templatePath = config != null ? (String)config.get("template") : null;
                        if (templatePath == null) {
                            log.error("Required template parameter not given");
                            htmlResponse = HtmlStatusResponseHelper.createStatusResponse(false, "Required template parameter not given");
                            break block11;
                        }
                        PageManager pm = request.getResourceResolver().adaptTo(PageManager.class);
                        Template template = pm.getTemplate(templatePath);
                        Node tNode = template.adaptTo(Node.class);
                        String resourceType = tNode.getNode("jcr:content").getProperty("sling:resourceType").getString();
                        OfflineImporter importer = new OfflineImporter(node, request.getRequestParameter("document"));
                        importer.setFilename(this.formatFileName(request.getRequestParameter("document").getFileName()));
                        importer.setResourceType(resourceType);
                        importer.setTemplate(templatePath);
                        importer.setConfig(config);
                        try {
                            importer.importDocument();
                            node.getSession().save();
                        }
                        finally {
                            node.refresh(false);
                        }
                        htmlResponse = HtmlStatusResponseHelper.createStatusResponse(true, "Document got imported");
                    }
                    catch (Exception e) {
                        log.error("Error while importing document", e);
                        htmlResponse = HtmlStatusResponseHelper.createStatusResponse(false, "Error while importing document: " + e.getMessage());
                    }
                }
            } else {
                htmlResponse = HtmlStatusResponseHelper.createStatusResponse(false, "Cannot import due of missing document");
            }
        }
        htmlResponse.send(response, true);
    }

    private String formatFileName(String fileName) {
        if (fileName.contains("\\")) {
            return fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        return fileName;
    }

    private ValueMap getConfig(SlingHttpServletRequest request) {
        String configPath = request.getParameter("configPath");
        if (configPath != null) {
            Resource config = request.getResourceResolver().getResource(configPath);
            return config.adaptTo(ValueMap.class);
        }
        return null;
    }

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestPathInfo().getSelectorString().indexOf("offlinecomponents") >= 0) {
            try {
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                ResourceResolver resolver = request.getResourceResolver();
                ComponentManager compMgr = resolver.adaptTo(ComponentManager.class);
                ArrayList<JSONObject> components = new ArrayList<JSONObject>();
                for (com.day.cq.wcm.api.components.Component cmp : compMgr.getComponents()) {
                    JSONObject o = new JSONObject();
                    String title = cmp.getTitle();
                    String text = (title == null || title.length() == 0 ? "" : title + " ") + "(" + cmp.getPath() + ")";
                    o.put("text", text);
                    o.put("value", cmp.getPath());
                    components.add(o);
                }
                Collections.sort(components, new Comparator<JSONObject>(){

                    @Override
                    public int compare(JSONObject one, JSONObject two) {
                        try {
                            return one.getString("text").compareToIgnoreCase(two.getString("text"));
                        }
                        catch (JSONException ex) {
                            return 0;
                        }
                    }
                });
                JSONObject result = new JSONObject();
                result.put("results", components.size());
                result.put("components", components);
                result.write(response.getWriter());
            }
            catch (JSONException ex) {
                log.error("Error while getting components", ex);
                throw new ServletException((Throwable)ex);
            }
        }
        String parentPath = request.getParameter("parent");
        Node node = parentPath == null ? request.getResource().adaptTo(Node.class) : request.getResourceResolver().getResource(parentPath).adaptTo(Node.class);
        if (node != null) {
            try {
                int level = 0;
                String subpages = request.getParameter("subpages");
                if (subpages != null && !"".equals(subpages)) {
                    try {
                        level = Integer.parseInt(subpages);
                    }
                    catch (NumberFormatException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                response.setContentType("application/msword");
                OfflineExporter.export(node, level, (OutputStream)response.getOutputStream());
            }
            catch (RepositoryException e) {
                throw new ServletException((Throwable)e);
            }
        }
        response.sendError(404);
    }
}

