/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.event;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.event.WorkflowEvent;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.job.AbsoluteTimeoutHandler;
import com.day.cq.workflow.job.ExternalProcessJob;
import com.day.cq.workflow.job.TimeoutJob;
import com.day.cq.workflow.job.WorkflowJob;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublishUtil {
    private static final Logger log = LoggerFactory.getLogger(EventPublishUtil.class);
    private EventAdmin eventAdmin;

    public EventPublishUtil(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    private void sendEvent(Dictionary<String, Object> props) {
        log.debug("Sending workflow event of type " + props.get("EventType") + (props.get("WorkflowInstanceId") != null ? " for " + props.get("WorkflowInstanceId") : ""));
        this.eventAdmin.sendEvent(new WorkflowEvent(props));
    }

    public void publishModelDeployedEvent(String id, String version, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "ModelDeployed");
        ((Dictionary)properties).put("WorkflowName", id);
        if (version != null) {
            ((Dictionary)properties).put("WorkflowVersion", version);
        } else {
            log.warn("No version specified");
        }
        this.sendEvent(properties);
    }

    public void publishModelDeletedEvent(String id, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "ModelDeleted");
        ((Dictionary)properties).put("WorkflowName", id);
        this.sendEvent(properties);
    }

    public void publishWorkflowStartedEvent(Workflow instance, Workflow parentWorkflow, String user, WorkflowData data) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowStarted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("Workdata", data);
        this.sendEvent(properties);
    }

    public void publishWorkflowAbortedEvent(Workflow instance, String userId) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", userId);
        ((Dictionary)properties).put("EventType", "WorkflowAborted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        this.sendEvent(properties);
    }

    public void publishWorkflowSuspendedEvent(Workflow instance, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowSuspended");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        this.sendEvent(properties);
    }

    public void publishWorkflowResumedEvent(Workflow instance, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowResumed");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        this.sendEvent(properties);
    }

    public void publishWorkflowCompletedEvent(Workflow instance, String user) throws WorkflowException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkflowCompleted");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        this.sendEvent(properties);
    }

    public void publishNodeTransitionEvent(Workflow instance, String fromNodeName, String toNodeName, WorkItem workitem, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "NodeTransition");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("fromNodeName", fromNodeName);
        ((Dictionary)properties).put("toNodeName", toNodeName);
        ((Dictionary)properties).put("Workitem", workitem);
        this.sendEvent(properties);
    }

    public void publishVariableUpdatedEvent(Workflow instance, String variableName, Object variableValue, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "VariableUpdate");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        ((Dictionary)properties).put("VariableName", variableName);
        ((Dictionary)properties).put("VariableValue", variableValue);
        this.sendEvent(properties);
    }

    public void publishProcessTimeoutEvent(Workflow instance, String processName) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("EventType", "ProcessTimeout");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        this.sendEvent(properties);
    }

    public void publishJobEvent(Map workItemMap, Integer retryCount, int numOfParallelProcs, String jobId) {
        WorkflowJob job = new WorkflowJob(workItemMap);
        this.eventAdmin.postEvent(job.createJobEvent(retryCount, numOfParallelProcs, jobId));
    }

    public void publishExternalProcessJobEvent(Map workItemMap, Integer retryCount, String jobId) {
        ExternalProcessJob job = new ExternalProcessJob(workItemMap);
        this.eventAdmin.postEvent(job.createJobEvent(retryCount, jobId));
    }

    public void publishJobFailedEvent(WorkItem item, String message) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("EventType", "JobFailed");
        ((Dictionary)properties).put("WorkflowNode", item.getNode().getId());
        ((Dictionary)properties).put("WorkflowName", item.getWorkflow().getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", item.getWorkflow().getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", item.getWorkflow().getId());
        this.sendEvent(properties);
    }

    public void publishTimeoutEvent(WorkItem item, WorkflowSession session) {
        AbsoluteTimeoutHandler handlerImpl;
        log.debug("entering publishTimeoutEvent..");
        String handler = null;
        Long timeout = null;
        boolean addOffset = true;
        for (String key : item.getNode().getMetaDataMap().keySet()) {
            if (key.equals("timeoutHandler")) {
                handler = (String)((Object)item.getNode().getMetaDataMap().get("timeoutHandler", String.class));
                continue;
            }
            if (!key.equals("timeoutMillis")) continue;
            timeout = (Long)((Object)item.getNode().getMetaDataMap().get("timeoutMillis", Long.class));
        }
        AbsoluteTimeoutHandler absoluteTimeoutHandler = handlerImpl = handler != null ? this.getHandler(handler, session) : null;
        if (handlerImpl != null) {
            timeout = handlerImpl.getTimeoutDate(item);
            if (timeout > 0L) {
                timeout = timeout / 1000L;
                addOffset = false;
                log.debug("publishTimeoutEvent: Using AbsoluteTimeoutHandler. Timeout is: " + timeout + "s");
            } else {
                log.debug("publishTimeoutEvent: no time set");
                timeout = null;
            }
        }
        if (handler != null && timeout != null) {
            TimeoutJob job = new TimeoutJob(item, handler);
            this.eventAdmin.postEvent(job.createEvent(true, timeout, addOffset));
        }
    }

    public void publishResetTimeoutEvent(WorkItem item) {
        String handler = null;
        for (String key : item.getNode().getMetaDataMap().keySet()) {
            if (!key.equals("timeoutHandler")) continue;
            handler = (String)((Object)item.getNode().getMetaDataMap().get("timeoutHandler", String.class));
        }
        if (handler != null) {
            TimeoutJob job = new TimeoutJob(item, handler);
            this.eventAdmin.postEvent(job.cancelEvent(true));
        }
    }

    public void publishDelegationEvent(Workflow instance, Authorizable participant, WorkItem item, String user) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("TimeStamp", new Date());
        ((Dictionary)properties).put("User", user);
        ((Dictionary)properties).put("EventType", "WorkItemDelegated");
        ((Dictionary)properties).put("WorkflowName", instance.getWorkflowModel().getTitle());
        ((Dictionary)properties).put("WorkflowVersion", instance.getWorkflowModel().getVersion());
        ((Dictionary)properties).put("WorkflowInstanceId", instance.getId());
        try {
            ((Dictionary)properties).put("Delagatee", participant.getID());
        }
        catch (RepositoryException e) {
            log.error("Unable to get ID for Authorizable.", e);
        }
        ((Dictionary)properties).put("Workitem", item);
        this.sendEvent(properties);
    }

    public void publishResourceCollectionModificationEvent(String path) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("Path", path);
        ((Dictionary)properties).put("EventType", "ResourceCollectionModified");
        this.sendEvent(properties);
    }

    private AbsoluteTimeoutHandler getHandler(String handler, WorkflowSession session) {
        ComponentContext context = (ComponentContext)session.getWorkflowService().getConfig().get("componentContext");
        if (context != null && context.getBundleContext() != null) {
            try {
                Object service;
                ServiceReference[] refs = context.getBundleContext().getAllServiceReferences(AbsoluteTimeoutHandler.class.getName(), null);
                ServiceReference ref = this.getServiceRef(refs, handler);
                if (ref != null && (service = context.getBundleContext().getService(ref)) instanceof AbsoluteTimeoutHandler) {
                    return (AbsoluteTimeoutHandler)service;
                }
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ServiceReference getServiceRef(ServiceReference[] refs, String handler) {
        for (ServiceReference ref : refs) {
            String componentName = (String)ref.getProperty("component.name");
            if (!componentName.equals(handler)) continue;
            return ref;
        }
        return null;
    }
}

