/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.job;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;

public class ExternalProcessJob
implements Serializable {
    private static final long serialVersionUID = 5718625605490930738L;
    public static final String JOB_TOPIC = "com/day/cq/workflow/external/job";
    public static final String JOB_TOPIC_WC = "com/day/cq/workflow/external/job/*";
    public static final String WORKFLOW_JOB = "com.day.cq.workflow.job";
    public static final String WORKFLOW_JOB_ID = "com.day.cq.workflow.jobid";
    protected Map serializedItem;

    public ExternalProcessJob(Map serializedItem) {
        if (serializedItem == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        this.serializedItem = serializedItem;
    }

    public Map getWorkItemMap() {
        return this.serializedItem;
    }

    public Event createJobEvent(Integer retryCount, String jobId) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(WORKFLOW_JOB, this);
        ((Dictionary)props).put("event.job.retries", retryCount);
        if (this.serializedItem.get("workflowModelId") != null) {
            String workflowModelId = (String)this.serializedItem.get("workflowModelId");
            workflowModelId = workflowModelId.replace(":", "_");
            ((Dictionary)props).put("event.job.topic", JOB_TOPIC + workflowModelId);
        } else {
            ((Dictionary)props).put("event.job.topic", JOB_TOPIC);
        }
        ((Dictionary)props).put(WORKFLOW_JOB_ID, jobId);
        return new Event("org/apache/sling/event/job", (Dictionary<String, ?>)props);
    }
}

