/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.packaging.gfx;

import com.day.crx.packaging.gfx.DownloadResource;
import com.day.crx.packaging.gfx.ImageHelper;
import com.day.crx.packaging.gfx.ImageResource;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import javax.jcr.RepositoryException;

public class GfxHelper {
    static final String GFX_MASK_ALPHA_PATH = "com/day/crx/packaging/mask.gif";
    static final String GFX_MASK_GLARE_PATH = "com/day/crx/packaging/mask.png";

    public static Layer stampThumbnail(ImageResource image) throws IOException, RepositoryException {
        if (!image.hasContent()) {
            return null;
        }
        Layer layer = image.getLayer(false, false, false);
        image.crop(layer);
        int w = layer.getWidth();
        int h = layer.getHeight();
        if (h < w) {
            image.set("height", "64");
        } else {
            image.set("width", "64");
        }
        image.resize(layer);
        layer.crop(new Rectangle(0, 0, 64, 64));
        image.rotate(layer);
        Layer alpha = ImageHelper.createLayer(DownloadResource.class.getClassLoader(), GFX_MASK_ALPHA_PATH);
        Layer alpha2 = new Layer(layer.getWidth(), layer.getHeight(), Color.WHITE);
        alpha2.copyChannel(layer, 3, 0);
        alpha2.copyChannel(alpha, 0, 3);
        alpha2.flatten(Color.BLACK);
        layer.copyChannel(alpha2, 0, 3);
        Layer mask = ImageHelper.createLayer(DownloadResource.class.getClassLoader(), GFX_MASK_GLARE_PATH);
        layer.merge(mask);
        return layer;
    }

    public static Layer stampScreenshot(ImageResource image) throws IOException, RepositoryException {
        return GfxHelper.stampScreenshot(image, false);
    }

    public static Layer stampScreenshot(ImageResource image, boolean notNull) throws IOException, RepositoryException {
        if (!image.hasContent()) {
            return null;
        }
        Layer layer = image.getLayer(false, false, false);
        boolean modified = false;
        if (layer != null) {
            modified = image.crop(layer) != null;
            modified |= image.resize(layer) != null;
            modified |= image.rotate(layer) != null;
        }
        if (modified || notNull) {
            return layer;
        }
        return null;
    }
}

