/*
 * Decompiled with CFR 0.152.
 */
package com.day.durbo;

import com.day.durbo.DurboInput;
import com.day.durbo.DurboValue;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.PropertyType;

public class DurboUtil {
    private static final String BLANKS = "                                                                                                                   ";

    private static void dump(DurboInput in, PrintWriter out) throws IOException {
        String[] nsp;
        DurboInput.Element elem;
        int indent = 0;
        out.println("DurboSer: Version " + in.getVersion());
        out.println("Encoding: " + in.getEncoding());
        out.println("ContentType: " + in.getContentType());
        while ((elem = in.read()) != null) {
            if (elem.isProperty()) {
                DurboValue[] values;
                DurboInput.Property p = (DurboInput.Property)elem;
                out.print(BLANKS.substring(0, indent));
                out.print(p.name());
                String delim = ": ";
                for (DurboValue value : values = p.getValues()) {
                    out.print(delim);
                    if (p.getType() == 2) {
                        out.print("<binary, size=" + value.getLength() + ">");
                    } else {
                        out.print(value.getString());
                    }
                    delim = ", ";
                }
                out.print("  (");
                out.print(PropertyType.nameFromValue((int)p.getType()));
                if (p.isMultiple()) {
                    out.println("[])");
                    continue;
                }
                out.println(")");
                continue;
            }
            if (elem.isNodeStart()) {
                out.print(BLANKS.substring(0, indent));
                out.println(elem.name());
                out.print(BLANKS.substring(0, indent += 2));
                out.println("{");
                continue;
            }
            if (!elem.isNodeEnd()) continue;
            out.print(BLANKS.substring(0, indent));
            out.println("}");
            indent -= 2;
        }
        out.println("used namespaces:");
        for (String aNsp : nsp = in.getPrefixes()) {
            out.println("  " + aNsp + ":" + in.getURI(aNsp));
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream(args[0]);
            DurboInput din = new DurboInput(in);
            DurboUtil.dump(din, new PrintWriter(System.out, true));
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

