/*
 * Decompiled with CFR 0.152.
 */
package com.day.durbo.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ChunkedDeflaterOutputStream
extends DeflaterOutputStream {
    private long autoRestart = Long.MAX_VALUE;

    public ChunkedDeflaterOutputStream(OutputStream out) {
        super(out);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def) {
        super(out, def);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def, int size) {
        super(out, def, size);
    }

    public long restart() throws IOException {
        this.finish();
        long ret = this.def.getTotalOut();
        this.def.reset();
        return ret;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if ((long)this.def.getTotalOut() > this.autoRestart) {
            this.restart();
        }
    }

    public void setAutoRestart(long len) {
        this.autoRestart = len;
    }
}

