/*
 * Decompiled with CFR 0.152.
 */
package com.day.imageio.plugins;

import com.day.imageio.plugins.GIFImageMetadata;
import com.day.imageio.plugins.GIFStreamMetadata;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

class GifImageWriter
extends ImageWriter {
    protected ImageOutputStream stream = null;
    private boolean streamInitialized = false;
    private static final int BLOCKLEN = 255;
    private static final int BUFLEN = 1000;
    int chainlen = 0;
    int maxchainlen = 0;
    int nodecount = 0;
    int lookuptypes = 0;
    int nbits;
    long obits;
    byte[] buffer;
    private short need = (short)8;
    GifTree root = new GifTree(76);

    protected GifImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        try {
            this.stream = (ImageOutputStream)output;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("output not ImageOutputStream");
        }
        this.streamInitialized = false;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return new GIFStreamMetadata();
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData must not be null");
        }
        if (inData instanceof GIFStreamMetadata) {
            return inData;
        }
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new GIFImageMetadata();
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData must not be null");
        }
        if (inData instanceof GIFImageMetadata) {
            return inData;
        }
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IIOException {
        boolean useGlobalColorTable;
        IndexColorModel icm;
        if (this.stream == null) {
            throw new IllegalStateException("output not yet set");
        }
        if (image == null) {
            throw new IllegalArgumentException("image must not be null");
        }
        RenderedImage rim = image.getRenderedImage();
        if (rim == null) {
            throw new UnsupportedOperationException("Image not a RenderedImage");
        }
        IIOMetadata imd = image.getMetadata();
        GIFImageMetadata metadata = null;
        if (imd != null) {
            metadata = (GIFImageMetadata)this.convertImageMetadata(imd, null, null);
        }
        if (metadata == null) {
            metadata = new GIFImageMetadata();
        }
        GIFStreamMetadata gifMetaData = streamMetadata == null ? new GIFStreamMetadata() : (GIFStreamMetadata)streamMetadata;
        ColorModel cm = rim.getColorModel();
        if (cm instanceof IndexColorModel) {
            icm = (IndexColorModel)cm;
            if (icm.getMapSize() > 256) {
                throw new UnsupportedOperationException("Number of colors > 256");
            }
        } else {
            throw new UnsupportedOperationException("Image must have IndexColorModel");
        }
        int colTabLen = icm.getMapSize();
        int depth = colTabLen <= 2 ? 1 : (colTabLen <= 4 ? 2 : (colTabLen <= 8 ? 3 : (colTabLen <= 16 ? 4 : (colTabLen <= 32 ? 5 : (colTabLen <= 64 ? 6 : (colTabLen <= 128 ? 7 : 8))))));
        int mapSize = 1 << depth;
        int[] rgba = new int[colTabLen];
        byte[] gifColTab = new byte[mapSize * 3];
        icm.getRGBs(rgba);
        int j = 0;
        for (int i = 0; i < colTabLen; ++i) {
            int col = rgba[i];
            gifColTab[j++] = (byte)(col >> 16);
            gifColTab[j++] = (byte)(col >> 8);
            gifColTab[j++] = (byte)col;
        }
        boolean bl = useGlobalColorTable = !this.streamInitialized;
        if (useGlobalColorTable) {
            gifMetaData.globalColorTable = gifColTab;
            metadata.localColorTable = null;
        } else {
            metadata.localColorTable = gifColTab;
        }
        try {
            if (!this.streamInitialized) {
                this.startGifStream(gifMetaData);
                this.streamInitialized = true;
            }
            this.writeGifImageMetaData(metadata);
            this.writeCompressedImage(rim.getData(), depth);
            this.stream.flush();
        }
        catch (IOException ioe) {
            throw new IIOException(ioe.getMessage(), ioe);
        }
    }

    protected void setByteOrder() {
        this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    private void startGifStream(GIFStreamMetadata streamMetadata) throws IOException {
        this.setByteOrder();
        this.stream.write("GIF89a".getBytes());
        this.stream.writeShort(streamMetadata.logicalScreenWidth);
        this.stream.writeShort(streamMetadata.logicalScreenHeight);
        byte packed = (byte)((streamMetadata.globalColorTable != null ? 1 : 0) << 7);
        packed = (byte)(packed | 0x70);
        if (streamMetadata.globalColorTable != null) {
            int i = -2;
            for (int nc = streamMetadata.globalColorTable.length / 3; nc > 0; nc >>= 1) {
                ++i;
            }
            packed = (byte)(packed | i);
        }
        this.stream.write(packed);
        this.stream.write(streamMetadata.backgroundColorIndex);
        this.stream.write(0);
        if (streamMetadata.globalColorTable != null) {
            this.stream.write(streamMetadata.globalColorTable);
        }
        if (streamMetadata.extensions != null) {
            for (int i = 0; i < streamMetadata.extensions.length; ++i) {
                GIFStreamMetadata.ApplicationExtension ext = streamMetadata.extensions[i];
                this.stream.write(33);
                this.stream.write(255);
                byte[] block11 = "\u000b           ".getBytes();
                int idLen = Math.min(ext.identifier.length, 8);
                System.arraycopy(ext.identifier, 0, block11, 1, idLen);
                idLen = Math.min(ext.authCode.length, 3);
                System.arraycopy(ext.authCode, 0, block11, 9, idLen);
                this.stream.write(block11);
                for (int j = 0; j < ext.subBlocks.length; ++j) {
                    this.stream.write(ext.subBlocks[j].length);
                    this.stream.write(ext.subBlocks[j]);
                }
                this.stream.write(0);
            }
        }
    }

    public void reset() {
        this.streamInitialized = false;
        super.reset();
    }

    public void dispose() {
        if (this.stream != null) {
            try {
                this.stream.write(59);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streamInitialized = false;
        }
        super.dispose();
    }

    private void writeGifImageMetaData(GIFImageMetadata metadata) throws IOException {
        this.stream.write(33);
        this.stream.write(249);
        this.stream.write(4);
        int packed = 0;
        packed = (byte)(packed | (metadata.disposalMethod & 7) << 2);
        packed = (byte)(packed | (metadata.transparentColorFlag ? 1 : 0));
        this.stream.write(packed);
        this.stream.writeShort(metadata.delayTime);
        this.stream.write(metadata.transparentColorIndex);
        this.stream.write(0);
        this.stream.write(44);
        this.stream.writeShort(metadata.imageLeftPosition);
        this.stream.writeShort(metadata.imageTopPosition);
        this.stream.writeShort(metadata.imageWidth);
        this.stream.writeShort(metadata.imageHeight);
        packed = (byte)((metadata.localColorTable != null ? 1 : 0) << 7);
        if (metadata.localColorTable != null) {
            int i = -2;
            for (int nc = metadata.localColorTable.length / 3; nc > 0; nc >>= 1) {
                ++i;
            }
            packed = (byte)(packed | i);
        }
        this.stream.write(packed);
        if (metadata.localColorTable != null) {
            this.stream.write(metadata.localColorTable);
        }
    }

    private void writeCompressedImage(Raster data, int depth) throws IOException {
        int w = data.getWidth();
        int h = data.getHeight();
        int[] chunk = new int[w];
        GifTree first = this.root;
        this.buffer = new byte[1000];
        int pos = 0;
        int cc = depth == 1 ? 4 : 1 << depth;
        int cLength = depth == 1 ? 3 : depth + 1;
        int eoi = cc + 1;
        int next = cc + 2;
        this.stream.write(cLength - 1);
        this.clearTree(cc, first);
        pos = this.addCodeToBuffer(cc, cLength, pos);
        GifTree curNode = first;
        for (int y = 0; y < h; ++y) {
            data.getSamples(0, y, w, 1, 0, chunk);
            int x = 0;
            while (x < w) {
                GifTree newNode;
                int curPix = chunk[x];
                if (curNode.node != null && curNode.node[curPix] != null) {
                    curNode = curNode.node[curPix];
                    ++this.chainlen;
                    ++x;
                    continue;
                }
                if (curNode.type == 83) {
                    newNode = curNode.nxt;
                    while (newNode.alt != null && newNode.idx != curPix) {
                        newNode = newNode.alt;
                    }
                    if (newNode.idx == curPix) {
                        ++this.chainlen;
                        curNode = newNode;
                        ++x;
                        continue;
                    }
                }
                newNode = new GifTree(84, next, curPix);
                switch (curNode.type) {
                    case 76: {
                        curNode.node[curPix] = newNode;
                        break;
                    }
                    case 83: {
                        curNode.node = new GifTree[256];
                        curNode.type = (byte)76;
                        curNode.node[curPix] = newNode;
                        curNode.node[curNode.nxt.idx] = curNode.nxt;
                        ++this.lookuptypes;
                        curNode.nxt = null;
                        break;
                    }
                    case 84: {
                        newNode.alt = curNode.nxt;
                        newNode.nxt = null;
                        curNode.nxt = newNode;
                        curNode.type = (byte)83;
                        break;
                    }
                }
                ++this.nodecount;
                pos = this.addCodeToBuffer(curNode.code, cLength, pos);
                if (this.chainlen > this.maxchainlen) {
                    this.maxchainlen = this.chainlen;
                }
                this.chainlen = 0;
                if (pos >= 255) {
                    this.stream.write(255);
                    this.stream.write(this.buffer, 0, 255);
                    this.buffer[0] = this.buffer[255];
                    this.buffer[1] = this.buffer[256];
                    this.buffer[2] = this.buffer[257];
                    this.buffer[3] = this.buffer[258];
                    pos -= 255;
                }
                curNode = first;
                if (next == 1 << cLength) {
                    ++cLength;
                }
                if (++next != 4095) continue;
                this.clearTree(cc, first);
                pos = this.addCodeToBuffer(cc, cLength, pos);
                if (pos >= 255) {
                    this.stream.write(255);
                    this.stream.write(this.buffer, 0, 255);
                    this.buffer[0] = this.buffer[255];
                    this.buffer[1] = this.buffer[256];
                    this.buffer[2] = this.buffer[257];
                    this.buffer[3] = this.buffer[258];
                    pos -= 255;
                }
                next = cc + 2;
                cLength = depth == 1 ? 3 : depth + 1;
            }
        }
        if ((pos = this.addCodeToBuffer(curNode.code, cLength, pos)) >= 252) {
            this.stream.write(252);
            this.stream.write(this.buffer, 0, 252);
            this.buffer[0] = this.buffer[252];
            this.buffer[1] = this.buffer[253];
            this.buffer[2] = this.buffer[254];
            this.buffer[3] = this.buffer[255];
            this.buffer[4] = this.buffer[256];
            pos -= 252;
        }
        pos = this.addCodeToBuffer(eoi, cLength, pos);
        pos = this.addCodeToBuffer(0, -1, pos);
        this.stream.write(pos);
        this.stream.write(this.buffer, 0, pos);
        this.stream.write(0);
    }

    private void clearTree(int cc, GifTree root) {
        int i;
        this.maxchainlen = 0;
        this.lookuptypes = 1;
        this.nodecount = cc;
        if (root.node == null) {
            root.node = new GifTree[256];
        } else {
            for (i = cc; i < root.node.length; ++i) {
                root.node[i] = null;
            }
        }
        for (i = 0; i < cc; ++i) {
            root.node[i] = new GifTree(84, i, i);
        }
    }

    private int addCodeToBuffer(int code, int n, int pos) {
        int mask;
        if (n < 0) {
            if (this.need < 8) {
                this.buffer[++pos] = 0;
            }
            this.need = (short)8;
            return pos;
        }
        while (n >= this.need) {
            mask = (1 << this.need) - 1;
            int n2 = pos++;
            this.buffer[n2] = (byte)(this.buffer[n2] + ((mask & code) << 8 - this.need));
            this.buffer[pos] = 0;
            code >>= this.need;
            n -= this.need;
            this.need = (short)8;
        }
        if (n != 0) {
            mask = (1 << n) - 1;
            int n3 = pos;
            this.buffer[n3] = (byte)(this.buffer[n3] + ((mask & code) << 8 - this.need));
            this.need = (short)(this.need - n);
        }
        return pos;
    }

    private static final class GifTree {
        static final byte TERMIN = 84;
        static final byte LOOKUP = 76;
        static final byte SEARCH = 83;
        byte type;
        int code;
        int idx;
        GifTree[] node;
        GifTree nxt;
        GifTree alt;

        GifTree(byte type) {
            this.type = type;
        }

        GifTree(byte type, int code, int idx) {
            this.type = type;
            this.code = code;
            this.idx = idx;
        }

        GifTree() {
        }
    }
}

