/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class BufferedRAFOutputStream
extends OutputStream {
    private final byte[] buffer = new byte[8192];
    private RandomAccessFile raf;
    private long bufferStart;
    private int bufferEnd;
    private byte[] one = new byte[1];

    public BufferedRAFOutputStream(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.bufferStart = raf.getFilePointer();
    }

    public void write(int b) throws IOException {
        this.one[0] = (byte)b;
        this.write(this.one, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this.buffer.length - this.bufferEnd) {
            this.flush();
            this.raf.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.buffer, this.bufferEnd, len);
            this.bufferEnd += len;
        }
    }

    public void flush() throws IOException {
        this.raf.write(this.buffer, 0, this.bufferEnd);
        this.bufferEnd = 0;
        this.bufferStart = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        this.flush();
        this.raf = null;
    }

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferEnd;
    }
}

