/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.util.TypeUtils;
import org.osgi.jmx.JmxConstants;

public class PropertyData<T> {
    private String key;
    private T value;
    private String encodedValue;
    private String encodedType;

    private PropertyData() {
    }

    private PropertyData(String key, T value, String preservedBaseType) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Argument key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument value cannot be null");
        }
        this.key = key;
        this.value = value;
        Class<?> type = value.getClass();
        if (type.isArray()) {
            this.encodedType = "Array of " + type.getComponentType().getSimpleName();
            StringBuilder builder = new StringBuilder();
            int length = Array.getLength(value);
            boolean useDelimiter = false;
            for (int i = 0; i < length; ++i) {
                if (useDelimiter) {
                    builder.append(",");
                } else {
                    useDelimiter = true;
                }
                builder.append(Array.get(value, i));
            }
            this.encodedValue = builder.toString();
        } else if (type.equals(Vector.class)) {
            Vector vector = (Vector)value;
            Class componentType = Object.class;
            if (vector.size() > 0) {
                componentType = vector.firstElement().getClass();
            }
            this.encodedType = "Vector of " + componentType.getSimpleName();
            StringBuilder builder = new StringBuilder();
            Vector valueVector = (Vector)value;
            boolean useDelimiter = false;
            for (Object val : valueVector) {
                if (useDelimiter) {
                    builder.append(",");
                } else {
                    useDelimiter = true;
                }
                builder.append(val);
            }
            this.encodedValue = builder.toString();
        } else if (List.class.isAssignableFrom(type)) {
            List list = (List)value;
            Class componentType = Object.class;
            if (list.size() > 0) {
                componentType = list.get(0).getClass();
            }
            this.encodedType = "Array of " + componentType.getSimpleName();
            StringBuilder builder = new StringBuilder();
            boolean useDelimiter = false;
            for (Object o : list) {
                if (useDelimiter) {
                    builder.append(",");
                } else {
                    useDelimiter = true;
                }
                builder.append(o);
            }
            this.encodedValue = builder.toString();
        } else {
            this.encodedType = preservedBaseType == null ? type.getSimpleName() : preservedBaseType;
            this.encodedValue = value.toString();
        }
    }

    public static <T> PropertyData<T> newInstance(String key, T value) throws IllegalArgumentException {
        return new PropertyData<T>(key, value, null);
    }

    public static PropertyData<Integer> newInstance(String key, int value) throws IllegalArgumentException {
        return new PropertyData<Integer>(key, value, "int");
    }

    public static PropertyData<Long> newInstance(String key, long value) throws IllegalArgumentException {
        return new PropertyData<Long>(key, value, "long");
    }

    public static PropertyData<Float> newInstance(String key, float value) throws IllegalArgumentException {
        return new PropertyData<Float>(key, Float.valueOf(value), "float");
    }

    public static PropertyData<Double> newInstance(String key, double value) throws IllegalArgumentException {
        return new PropertyData<Double>(key, value, "double");
    }

    public static PropertyData<Byte> newInstance(String key, byte value) throws IllegalArgumentException {
        return new PropertyData<Byte>(key, value, "byte");
    }

    public static PropertyData<Character> newInstance(String key, char value) throws IllegalArgumentException {
        return new PropertyData<Character>(key, Character.valueOf(value), "char");
    }

    public static PropertyData<Boolean> newInstance(String key, boolean value) throws IllegalArgumentException {
        return new PropertyData<Boolean>(key, value, "boolean");
    }

    public CompositeData toCompositeData() {
        CompositeDataSupport result = null;
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("Key", this.key);
        items.put("Value", this.encodedValue);
        items.put("Type", this.encodedType);
        try {
            result = new CompositeDataSupport(JmxConstants.PROPERTY_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for Property [" + this.key + ":" + this.value + "]", e);
        }
        return result;
    }

    public static <T> PropertyData<T> from(CompositeData compositeData) throws IllegalArgumentException {
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(JmxConstants.PROPERTY_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        PropertyData<T> propertyData = new PropertyData<T>();
        propertyData.key = (String)compositeData.get("Key");
        propertyData.encodedType = (String)compositeData.get("Type");
        propertyData.encodedValue = (String)compositeData.get("Value");
        if (propertyData.encodedType == null || propertyData.encodedType.length() < 1) {
            throw new IllegalArgumentException("Cannot determine type from compositeData : " + compositeData);
        }
        StringTokenizer values = new StringTokenizer(propertyData.encodedValue, ",");
        int valuesLength = values.countTokens();
        if (propertyData.encodedType.startsWith("Array of ")) {
            String[] arrayTypeParts = propertyData.encodedType.split("\\s");
            if (arrayTypeParts.length < 3) {
                throw new IllegalArgumentException("Cannot parse Array type from type item : " + propertyData.encodedType);
            }
            String arrayTypeName = arrayTypeParts[2].trim();
            if (!TypeUtils.types.containsKey(arrayTypeName)) {
                throw new IllegalArgumentException("Cannot determine type from value : " + arrayTypeName);
            }
            Class arrayType = (Class)TypeUtils.types.get(arrayTypeName);
            propertyData.value = Array.newInstance(arrayType, valuesLength);
            int index = 0;
            while (values.hasMoreTokens()) {
                Array.set(propertyData.value, index++, TypeUtils.fromString((Class)arrayType, (String)values.nextToken()));
            }
        } else if (propertyData.encodedType.startsWith("Vector of ")) {
            String[] vectorTypeParts = propertyData.encodedType.split("\\s");
            if (vectorTypeParts.length < 3) {
                throw new IllegalArgumentException("Cannot parse Array type from type item : " + propertyData.encodedType);
            }
            String vectorTypeName = vectorTypeParts[2].trim();
            if (!TypeUtils.types.containsKey(vectorTypeName)) {
                throw new IllegalArgumentException("Cannot determine type from value : " + vectorTypeName);
            }
            Class vectorType = (Class)TypeUtils.types.get(vectorTypeName);
            Vector<Object> vector = new Vector<Object>();
            while (values.hasMoreTokens()) {
                vector.add(TypeUtils.fromString((Class)vectorType, (String)values.nextToken()));
            }
            propertyData.value = vector;
        } else {
            if (!TypeUtils.types.containsKey(propertyData.encodedType)) {
                throw new IllegalArgumentException("Cannot determine type from value : " + propertyData.encodedType);
            }
            Class valueType = (Class)TypeUtils.types.get(propertyData.encodedType);
            propertyData.value = TypeUtils.fromString((Class)valueType, (String)propertyData.encodedValue);
        }
        return propertyData;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public String getEncodedType() {
        return this.encodedType;
    }

    public String getEncodedValue() {
        return this.encodedValue;
    }

    public boolean isEncodingPrimitive() {
        return TypeUtils.primitiveTypes.containsKey(this.encodedType);
    }
}

