/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.util.Debug;
import org.apache.commons.imaging.util.IoUtils;

public class JpegUtils
extends BinaryFileParser {
    public JpegUtils() {
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void traverseJFIF(ByteSource byteSource, Visitor visitor) throws ImageReadException, IOException {
        is = null;
        canThrow = false;
        try {
            is = byteSource.getInputStream();
            BinaryFunctions.readAndVerifyBytes(is, JpegConstants.SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            markerCount = 0;
lbl7:
            // 2 sources

            while (true) {
                markerBytes = new byte[]{markerBytes[1], BinaryFunctions.readByte("marker", is, "Could not read marker")};
                while ((255 & markerBytes[0]) != 255 || (255 & markerBytes[1]) == 255) {
                }
                marker = (255 & markerBytes[0]) << 8 | 255 & markerBytes[1];
                if (marker != 65497 && marker != 65498) ** GOTO lbl25
                if (!visitor.beginSOS()) {
                    canThrow = true;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var11_11) {
            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
            throw var11_11;
        }
        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
        return;
lbl-1000:
        // 1 sources

        {
            imageData = BinaryFunctions.getStreamBytes(is);
            visitor.visitSOS(marker, markerBytes, imageData);
            ** GOTO lbl33
lbl25:
            // 1 sources

            segmentLengthBytes = BinaryFunctions.readBytes("segmentLengthBytes", is, 2, "segmentLengthBytes");
            segmentLength = ByteConversions.toUInt16(segmentLengthBytes, this.getByteOrder());
            if (visitor.visitSegment(marker, markerBytes, segmentLength, segmentLengthBytes, segmentData = BinaryFunctions.readBytes("Segment Data", is, segmentLength - 2, "Invalid Segment: insufficient data"))) ** GOTO lbl-1000
            canThrow = true;
        }
        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
        return;
lbl-1000:
        // 1 sources

        {
            ++markerCount;
            ** continue;
lbl33:
            // 1 sources

            Debug.debug(Integer.toString(markerCount) + " markers");
            canThrow = true;
        }
        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
    }

    public static String getMarkerName(int marker) {
        switch (marker) {
            case 65498: {
                return "SOS_MARKER";
            }
            case 65505: {
                return "JPEG_APP1_MARKER";
            }
            case 65506: {
                return "JPEG_APP2_MARKER";
            }
            case 65517: {
                return "JPEG_APP13_MARKER";
            }
            case 65518: {
                return "JPEG_APP14_MARKER";
            }
            case 65519: {
                return "JPEG_APP15_MARKER";
            }
            case 65504: {
                return "JFIF_MARKER";
            }
            case 65472: {
                return "SOF0_MARKER";
            }
            case 65473: {
                return "SOF1_MARKER";
            }
            case 65474: {
                return "SOF2_MARKER";
            }
            case 65475: {
                return "SOF3_MARKER";
            }
            case 65476: {
                return "SOF4_MARKER";
            }
            case 65477: {
                return "SOF5_MARKER";
            }
            case 65478: {
                return "SOF6_MARKER";
            }
            case 65479: {
                return "SOF7_MARKER";
            }
            case 65480: {
                return "SOF8_MARKER";
            }
            case 65481: {
                return "SOF9_MARKER";
            }
            case 65482: {
                return "SOF10_MARKER";
            }
            case 65483: {
                return "SOF11_MARKER";
            }
            case 65484: {
                return "DAC_MARKER";
            }
            case 65485: {
                return "SOF13_MARKER";
            }
            case 65486: {
                return "SOF14_MARKER";
            }
            case 65487: {
                return "SOF15_MARKER";
            }
            case 65499: {
                return "DQT_MARKER";
            }
        }
        return "Unknown";
    }

    public void dumpJFIF(ByteSource byteSource) throws ImageReadException, IOException {
        Visitor visitor = new Visitor(){

            public boolean beginSOS() {
                return true;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                Debug.debug("SOS marker.  " + imageData.length + " bytes of image data.");
                Debug.debug("");
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) {
                Debug.debug("Segment marker: " + Integer.toHexString(marker) + " (" + JpegUtils.getMarkerName(marker) + "), " + segmentData.length + " bytes of segment data.");
                return true;
            }
        };
        this.traverseJFIF(byteSource, visitor);
    }

    public static interface Visitor {
        public boolean beginSOS();

        public void visitSOS(int var1, byte[] var2, byte[] var3);

        public boolean visitSegment(int var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws ImageReadException, IOException;
    }
}

