/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.rootcause;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.felix.systemready.rootcause.DSComp;
import org.apache.felix.systemready.rootcause.DSRef;

public class RootCausePrinter {
    private Consumer<String> printCallback;

    public RootCausePrinter() {
        this(System.out::println);
    }

    public RootCausePrinter(Consumer<String> printCallback) {
        this.printCallback = printCallback;
    }

    public void print(DSComp desc) {
        this.print(desc, 0);
    }

    public void print(DSComp comp, int level) {
        if (comp.config == null && "require".equals(comp.desc.configurationPolicy)) {
            this.println(level, "Component %s missing config on pid %s", comp.desc.name, Arrays.asList(comp.desc.configurationPid));
        } else if (comp.config != null && comp.config.state == 1) {
            this.println(level, "Component %s unsatisifed configuration on pid %s", comp.desc.name, Arrays.asList(comp.desc.configurationPid));
        } else if (!comp.unsatisfied.isEmpty()) {
            this.println(level, "Component %s unsatisfied references", comp.desc.name);
        } else {
            this.println(level, "Component %s satisfied", comp.desc.name);
        }
        int l2 = level + 2;
        int l3 = l2 + 2;
        for (DSRef ref : comp.unsatisfied) {
            this.println(l2, "unsatisfied ref %s interface %s %s", ref.name, ref.iface, this.getFilterSt(ref.filter));
            for (DSComp cand : ref.candidates) {
                this.print(cand, l3);
            }
        }
    }

    private Object getFilterSt(String filter) {
        return filter == null ? "" : ", filter " + filter;
    }

    private void println(int level, String format, Object ... args) {
        this.printCallback.accept(this.spaces(level) + String.format(format, args));
    }

    private String spaces(int length) {
        char[] bytes = new char[length];
        Arrays.fill(bytes, ' ');
        return new String(bytes);
    }
}

