/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.CommitTask;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RollbackTask;
import org.apache.geronimo.transaction.manager.SetRollbackOnlyException;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.TransactionTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger("Transaction");
    private final TransactionManagerImpl txManager;
    private final Xid xid;
    private final long timeout;
    private final List<Synchronization> syncList = new ArrayList<Synchronization>(5);
    private final List<Synchronization> interposedSyncList = new ArrayList<Synchronization>(3);
    private final LinkedList<TransactionBranch> resourceManagers = new LinkedList();
    private final IdentityHashMap<XAResource, TransactionBranch> activeXaResources = new IdentityHashMap(3);
    private final IdentityHashMap<XAResource, TransactionBranch> suspendedXaResources = new IdentityHashMap(3);
    private int status = 6;
    private Throwable markRollbackCause;
    private Object logMark;
    private final Map<Object, Object> resources = new HashMap<Object, Object>();

    TransactionImpl(TransactionManagerImpl txManager, long transactionTimeoutMilliseconds) throws SystemException {
        this(txManager.getXidFactory().createXid(), txManager, transactionTimeoutMilliseconds);
    }

    TransactionImpl(Xid xid, TransactionManagerImpl txManager, long transactionTimeoutMilliseconds) throws SystemException {
        this.txManager = txManager;
        this.xid = xid;
        this.timeout = transactionTimeoutMilliseconds + TransactionTimer.getCurrentTime();
        try {
            txManager.getTransactionLog().begin(xid);
        }
        catch (LogException e) {
            this.markRollbackCause(e);
            this.status = 1;
            SystemException ex = new SystemException("Error logging begin; transaction marked for roll back)");
            ex.initCause((Throwable)e);
            throw ex;
        }
        this.status = 0;
    }

    public TransactionImpl(Xid xid, TransactionManagerImpl txManager) {
        this.txManager = txManager;
        this.xid = xid;
        this.status = 2;
        this.timeout = Long.MAX_VALUE;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public Object getResource(Object key) {
        return this.resources.get(key);
    }

    public boolean getRollbackOnly() {
        return this.status == 1;
    }

    public Object getTransactionKey() {
        return this.xid;
    }

    public int getTransactionStatus() {
        return this.status;
    }

    public void putResource(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("You must supply a non-null key for putResource");
        }
        this.resources.put(key, value);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        this.interposedSyncList.add(synchronization);
    }

    public synchronized void setRollbackOnly() throws IllegalStateException {
        this.setRollbackOnly(new SetRollbackOnlyException());
    }

    public synchronized void setRollbackOnly(Throwable reason) {
        switch (this.status) {
            case 0: 
            case 7: {
                this.status = 1;
                this.markRollbackCause(reason);
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot set rollback only, status is " + TransactionImpl.getStateString(this.status));
            }
        }
    }

    public synchronized void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
        if (synch == null) {
            throw new IllegalArgumentException("Synchronization is null");
        }
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                throw new RollbackException("Transaction is marked for rollback");
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        this.syncList.add(synch);
    }

    public synchronized boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("XAResource is null");
        }
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        if (this.activeXaResources.containsKey(xaRes)) {
            throw new IllegalStateException("xaresource: " + xaRes + " is already enlisted!");
        }
        try {
            TransactionBranch manager2 = this.suspendedXaResources.remove(xaRes);
            if (manager2 != null) {
                xaRes.start(manager2.getBranchId(), 0x8000000);
                this.activeXaResources.put(xaRes, manager2);
                return true;
            }
            for (TransactionBranch manager2 : this.resourceManagers) {
                boolean sameRM;
                if (xaRes == manager2.getCommitter()) {
                    throw new IllegalStateException("xaRes " + xaRes + " is a committer but is not active or suspended");
                }
                try {
                    sameRM = xaRes.isSameRM(manager2.getCommitter());
                }
                catch (XAException e) {
                    log.warn("Unexpected error checking for same RM", e);
                    continue;
                }
                if (!sameRM) continue;
                xaRes.start(manager2.getBranchId(), 0x200000);
                this.activeXaResources.put(xaRes, manager2);
                return true;
            }
            Xid branchId = this.txManager.getXidFactory().createBranch(this.xid, this.resourceManagers.size() + 1);
            xaRes.start(branchId, 0);
            xaRes.setTransactionTimeout((int)(this.timeout - TransactionTimer.getCurrentTime()) / 1000);
            this.activeXaResources.put(xaRes, this.addBranchXid(xaRes, branchId));
            return true;
        }
        catch (XAException e) {
            log.warn("Unable to enlist XAResource " + xaRes + ", errorCode: " + e.errorCode, e);
            this.setRollbackOnly(e);
            return false;
        }
    }

    public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (flag != 0x20000000 && flag != 0x4000000 && flag != 0x2000000) {
            throw new IllegalStateException("invalid flag for delistResource: " + flag);
        }
        if (xaRes == null) {
            throw new IllegalArgumentException("XAResource is null");
        }
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        TransactionBranch manager = this.activeXaResources.remove(xaRes);
        if (manager == null) {
            if (flag == 0x2000000) {
                throw new IllegalStateException("trying to suspend an inactive xaresource: " + xaRes);
            }
            manager = this.suspendedXaResources.remove(xaRes);
            if (manager == null) {
                throw new IllegalStateException("Resource not known to transaction: " + xaRes);
            }
        }
        try {
            xaRes.end(manager.getBranchId(), flag);
            if (flag == 0x2000000) {
                this.suspendedXaResources.put(xaRes, manager);
            }
            return true;
        }
        catch (XAException e) {
            log.warn("Unable to delist XAResource " + xaRes + ", error code: " + e.errorCode, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        block40: {
            TransactionImpl rollbackException2;
            this.beforePrepare();
            try {
                if (TransactionTimer.getCurrentTime() > this.timeout) {
                    this.markRollbackCause(new Exception("Transaction has timed out"));
                    this.status = 1;
                }
                if (this.status == 1) {
                    this.rollbackResources(this.resourceManagers, false);
                    RollbackException rollbackException2 = new RollbackException("Unable to commit: transaction marked for rollback");
                    if (this.markRollbackCause != null) {
                        rollbackException2.initCause(this.markRollbackCause);
                    }
                    throw rollbackException2;
                }
                rollbackException2 = this;
                synchronized (rollbackException2) {
                    if (this.status == 0) {
                        this.status = this.resourceManagers.size() == 0 ? 3 : (this.resourceManagers.size() == 1 ? 8 : 7);
                    }
                }
                if (this.resourceManagers.size() == 0) {
                    rollbackException2 = this;
                    synchronized (rollbackException2) {
                        this.status = 3;
                    }
                    return;
                }
                if (this.resourceManagers.size() == 1) {
                    TransactionBranch manager = this.resourceManagers.getFirst();
                    this.commitResource(manager);
                    return;
                }
                boolean willCommit = false;
                try {
                    willCommit = this.internalPrepare();
                }
                catch (SystemException e) {
                    this.rollbackResources(this.resourceManagers, false);
                    throw e;
                }
                if (willCommit) {
                    if (this.resourceManagers.size() == 0) {
                        TransactionImpl transactionImpl = this;
                        synchronized (transactionImpl) {
                            this.status = 3;
                        }
                        return;
                    }
                    this.commitResources(this.resourceManagers);
                    break block40;
                }
                this.rollbackResources(this.resourceManagers, true);
                throw new RollbackException("transaction rolled back due to problems in prepare");
            }
            finally {
                this.afterCompletion();
                rollbackException2 = this;
                synchronized (rollbackException2) {
                    this.status = 6;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int prepare() throws SystemException, RollbackException {
        this.beforePrepare();
        int result = 3;
        try {
            LinkedList<TransactionBranch> rms;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.status == 0) {
                    if (this.resourceManagers.size() == 0) {
                        this.status = 3;
                        int n = result;
                        return n;
                    }
                    this.status = 7;
                }
                rms = this.resourceManagers;
            }
            boolean willCommit = this.internalPrepare();
            if (willCommit) {
                if (rms.isEmpty()) return result;
                result = 0;
                return result;
            }
            try {
                this.rollbackResources(rms, false);
                throw new RollbackException("Unable to commit");
            }
            catch (HeuristicMixedException e) {
                throw (SystemException)new SystemException("Unable to commit and heuristic exception during rollback").initCause((Throwable)e);
            }
        }
        finally {
            if (result == 3) {
                this.afterCompletion();
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    this.status = 6;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preparedCommit() throws HeuristicRollbackException, HeuristicMixedException, SystemException {
        try {
            this.commitResources(this.resourceManagers);
        }
        finally {
            this.afterCompletion();
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.status = 6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforePrepare() {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            switch (this.status) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
                }
            }
        }
        this.beforeCompletion();
        this.endResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalPrepare() throws SystemException {
        boolean willCommit;
        Object manager;
        Iterator rms = this.resourceManagers.iterator();
        while (rms.hasNext()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.status != 7) {
                    break;
                }
            }
            manager = (TransactionBranch)rms.next();
            try {
                int vote = ((TransactionBranch)manager).getCommitter().prepare(((TransactionBranch)manager).getBranchId());
                if (vote != 3) continue;
                rms.remove();
            }
            catch (XAException e) {
                if (e.errorCode == -3 || e.errorCode == -6 || e.errorCode == -5) {
                    throw (SystemException)new SystemException("Error during prepare; transaction was rolled back").initCause((Throwable)e);
                }
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.markRollbackCause(e);
                    this.status = 1;
                    break;
                }
            }
        }
        manager = this;
        synchronized (manager) {
            boolean bl = willCommit = this.status != 1;
            if (willCommit) {
                this.status = 2;
            }
        }
        if (willCommit && !this.resourceManagers.isEmpty()) {
            try {
                this.logMark = this.txManager.getTransactionLog().prepare(this.xid, this.resourceManagers);
            }
            catch (LogException e) {
                try {
                    this.rollbackResources(this.resourceManagers, false);
                }
                catch (Exception se) {
                    log.error("Unable to rollback after failure to log prepare", se.getCause());
                }
                throw (SystemException)new SystemException("Error logging prepare; transaction was rolled back)").initCause((Throwable)e);
            }
        }
        return willCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        LinkedList<TransactionBranch> rms;
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            switch (this.status) {
                case 0: {
                    this.status = 1;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
                }
            }
            rms = this.resourceManagers;
        }
        this.endResources();
        try {
            try {
                this.rollbackResources(rms, false);
            }
            catch (HeuristicMixedException e) {
                throw (SystemException)new SystemException("Unable to roll back due to heuristics").initCause((Throwable)e);
            }
        }
        finally {
            this.afterCompletion();
            transactionImpl = this;
            synchronized (transactionImpl) {
                this.status = 6;
            }
        }
    }

    private void beforeCompletion() {
        this.beforeCompletion(this.syncList);
        this.beforeCompletion(this.interposedSyncList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeCompletion(List syncs) {
        int i = 0;
        while (true) {
            Synchronization synch;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (i == syncs.size()) {
                    return;
                }
                synch = (Synchronization)syncs.get(i++);
            }
            try {
                synch.beforeCompletion();
            }
            catch (Exception e) {
                log.warn("Unexpected exception from beforeCompletion; transaction will roll back", e);
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.markRollbackCause(e);
                    this.status = 1;
                }
            }
        }
    }

    private void markRollbackCause(Throwable e) {
        if (this.markRollbackCause == null) {
            this.markRollbackCause = e;
        }
    }

    private void afterCompletion() {
        this.afterCompletion(this.interposedSyncList);
        this.afterCompletion(this.syncList);
    }

    private void afterCompletion(List syncs) {
        for (Synchronization synch : syncs) {
            try {
                synch.afterCompletion(this.status);
            }
            catch (Exception e) {
                log.warn("Unexpected exception from afterCompletion; continuing", e);
            }
        }
    }

    private void endResources() {
        this.endResources(this.activeXaResources);
        this.endResources(this.suspendedXaResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endResources(IdentityHashMap<XAResource, TransactionBranch> resourceMap) {
        while (true) {
            int flags;
            TransactionBranch manager;
            XAResource xaRes;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                Set<Map.Entry<XAResource, TransactionBranch>> entrySet = resourceMap.entrySet();
                if (entrySet.isEmpty()) {
                    return;
                }
                Map.Entry<XAResource, TransactionBranch> entry = entrySet.iterator().next();
                xaRes = entry.getKey();
                manager = entry.getValue();
                flags = this.status == 1 ? 0x20000000 : 0x4000000;
                resourceMap.remove(xaRes);
            }
            try {
                xaRes.end(manager.getBranchId(), flags);
            }
            catch (XAException e) {
                log.warn("Error ending association for XAResource " + xaRes + "; transaction will roll back. XA error code: " + e.errorCode, e);
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.markRollbackCause(e);
                    this.status = 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackResources(List<TransactionBranch> rms, boolean everRb) throws HeuristicMixedException, SystemException {
        boolean everRolledback;
        RollbackTask rollbackTask = new RollbackTask(this.xid, rms, this.logMark, this.txManager);
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 9;
        }
        rollbackTask.run();
        transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = rollbackTask.getStatus();
        }
        XAException cause = rollbackTask.getCause();
        boolean bl = everRolledback = everRb || rollbackTask.isEverRolledBack();
        if (cause != null) {
            if (cause.errorCode == 7 && everRolledback) {
                throw (HeuristicMixedException)new HeuristicMixedException("HeuristicMixed error during commit/rolling back").initCause((Throwable)cause);
            }
            if (cause.errorCode == 5) {
                throw (HeuristicMixedException)new HeuristicMixedException("HeuristicMixed error during commit/rolling back").initCause((Throwable)cause);
            }
            throw (SystemException)new SystemException("System Error during commit/rolling back").initCause((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResource(TransactionBranch manager) throws RollbackException, HeuristicRollbackException, HeuristicMixedException, SystemException {
        XAException cause = null;
        try {
            manager.getCommitter().commit(manager.getBranchId(), true);
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.status = 3;
            }
            return;
        }
        catch (XAException e) {
            block21: {
                try {
                    TransactionImpl transactionImpl = this;
                    synchronized (transactionImpl) {
                        this.status = 4;
                    }
                    if (e.errorCode == 6) {
                        cause = e;
                        manager.getCommitter().forget(manager.getBranchId());
                    } else {
                        if (e.errorCode == 5) {
                            cause = e;
                            manager.getCommitter().forget(manager.getBranchId());
                            throw (HeuristicMixedException)new HeuristicMixedException("Error during one-phase commit").initCause((Throwable)e);
                        }
                        if (e.errorCode == 7) {
                            log.info("Transaction has been heuristically committed");
                            manager.getCommitter().forget(manager.getBranchId());
                        } else if (e.errorCode == 100 || e.errorCode == -3 || e.errorCode == -4) {
                            log.info("Transaction has been rolled back");
                            cause = e;
                        } else {
                            cause = e;
                        }
                    }
                }
                catch (XAException e2) {
                    if (e2.errorCode == -4) break block21;
                    throw (SystemException)new SystemException("Error during one phase commit").initCause((Throwable)e2);
                }
            }
            if (cause != null) {
                if (cause.errorCode == 6) {
                    throw (HeuristicRollbackException)new HeuristicRollbackException("Error during two phase commit").initCause((Throwable)cause);
                }
                if (cause.errorCode == 5) {
                    throw (HeuristicMixedException)new HeuristicMixedException("Error during two phase commit").initCause((Throwable)cause);
                }
                if (cause.errorCode == 100 || cause.errorCode == -3 || cause.errorCode == -4) {
                    throw (RollbackException)new RollbackException("Error during two phase commit").initCause((Throwable)cause);
                }
                throw (SystemException)new SystemException("Error during two phase commit").initCause((Throwable)cause);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResources(List<TransactionBranch> rms) throws HeuristicRollbackException, HeuristicMixedException, SystemException {
        CommitTask commitTask = new CommitTask(this.xid, rms, this.logMark, this.txManager);
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 8;
        }
        commitTask.run();
        transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = commitTask.getStatus();
        }
        XAException cause = commitTask.getCause();
        boolean evercommit = commitTask.isEvercommit();
        if (cause != null) {
            if (cause.errorCode == 6 && !evercommit) {
                throw (HeuristicRollbackException)new HeuristicRollbackException("Error during two phase commit").initCause((Throwable)cause);
            }
            if (cause.errorCode == 6 && evercommit) {
                throw (HeuristicMixedException)new HeuristicMixedException("Error during two phase commit").initCause((Throwable)cause);
            }
            if (cause.errorCode == 5) {
                throw (HeuristicMixedException)new HeuristicMixedException("Error during two phase commit").initCause((Throwable)cause);
            }
            throw (SystemException)new SystemException("Error during two phase commit").initCause((Throwable)cause);
        }
    }

    private static String getStateString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransactionImpl) {
            TransactionImpl other = (TransactionImpl)obj;
            return this.xid.equals(other.xid);
        }
        return false;
    }

    public TransactionBranch addBranchXid(XAResource xaRes, Xid branchId) {
        TransactionBranch manager = new TransactionBranch(xaRes, branchId);
        this.resourceManagers.add(manager);
        return manager;
    }

    static class ReturnableTransactionBranch
    extends TransactionBranch {
        private final NamedXAResourceFactory namedXAResourceFactory;

        ReturnableTransactionBranch(Xid branchId, NamedXAResourceFactory namedXAResourceFactory) throws SystemException {
            super(namedXAResourceFactory.getNamedXAResource(), branchId);
            this.namedXAResourceFactory = namedXAResourceFactory;
        }

        public void returnXAResource() {
            this.namedXAResourceFactory.returnNamedXAResource((NamedXAResource)this.getCommitter());
        }
    }

    static class TransactionBranch
    implements TransactionBranchInfo {
        private final XAResource committer;
        private final Xid branchId;

        public TransactionBranch(XAResource xaRes, Xid branchId) {
            this.committer = xaRes;
            this.branchId = branchId;
        }

        public XAResource getCommitter() {
            return this.committer;
        }

        public Xid getBranchId() {
            return this.branchId;
        }

        @Override
        public String getResourceName() {
            if (this.committer instanceof NamedXAResource) {
                return ((NamedXAResource)this.committer).getName();
            }
            log.error("Please correct the integration and supply a NamedXAResource", new IllegalStateException("Cannot log transactions as " + this.committer + " is not a NamedXAResource."));
            return this.committer.toString();
        }

        @Override
        public Xid getBranchXid() {
            return this.branchId;
        }
    }
}

