/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.discovery.commons.providers.spi.base.AbstractServiceWithBackgroundCheck;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptor;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IdMapService.class}, property={"service.vendor=The Apache Software Foundation"})
public class IdMapService
extends AbstractServiceWithBackgroundCheck
implements ResourceChangeListener {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingSettingsService settingsService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DiscoveryLiteConfig commonsConfig;
    private boolean initialized = false;
    private String slingId;
    private long me;
    private final Map<Integer, String> oldIdMapCache = new HashMap<Integer, String>();
    private final Map<Integer, String> idMapCache = new HashMap<Integer, String>();
    private long lastCacheInvalidation = -1L;
    private BundleContext bundleContext;
    private volatile ServiceRegistration<ResourceChangeListener> eventHandlerRegistration;

    public static IdMapService testConstructor(DiscoveryLiteConfig commonsConfig, SlingSettingsService settingsService, ResourceResolverFactory resourceResolverFactory) {
        IdMapService service = new IdMapService();
        service.commonsConfig = commonsConfig;
        service.settingsService = settingsService;
        service.resourceResolverFactory = resourceResolverFactory;
        service.activate(null);
        return service;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.registerEventHandler();
        this.startBackgroundCheck("IdMapService-initializer", new AbstractServiceWithBackgroundCheck.BackgroundCheck(){

            @Override
            public boolean check() {
                try {
                    return IdMapService.this.init();
                }
                catch (Exception e) {
                    IdMapService.this.logger.error("initializer: could not init due to " + e, e);
                    return false;
                }
            }
        }, null, -1L, 1000L);
    }

    @Deactivate
    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        this.cancelPreviousBackgroundCheck();
    }

    private void registerEventHandler() {
        if (this.bundleContext == null) {
            this.logger.info("registerEventHandler: bundleContext is null - cannot register");
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "IdMap Change Listener.");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        String[] topics = new String[]{ResourceChange.ChangeType.ADDED.toString(), ResourceChange.ChangeType.CHANGED.toString(), ResourceChange.ChangeType.REMOVED.toString()};
        ((Dictionary)properties).put("resource.change.types", topics);
        ((Dictionary)properties).put("resource.paths", this.getIdMapPath());
        this.eventHandlerRegistration = this.bundleContext.registerService(ResourceChangeListener.class, (Object)this, properties);
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    public synchronized long getMyId() {
        if (!this.initialized) {
            return -1L;
        }
        return this.me;
    }

    public synchronized boolean waitForInit(long timeout) {
        long start = System.currentTimeMillis();
        while (!this.initialized && timeout != 0L) {
            try {
                if (timeout > 0L) {
                    long diff = start + timeout - System.currentTimeMillis();
                    if (diff <= 0L) {
                        return false;
                    }
                    this.wait(diff);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.initialized;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean init() throws LoginException, PersistenceException {
        if (this.initialized) {
            return true;
        }
        this.slingId = this.settingsService.getSlingId();
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = this.getResourceResolver();
            DiscoveryLiteDescriptor descriptor = DiscoveryLiteDescriptor.getDescriptorFrom(resourceResolver);
            long me = descriptor.getMyId();
            Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, this.getIdMapPath());
            ModifiableValueMap idmap = resource.adaptTo(ModifiableValueMap.class);
            boolean foundMe = false;
            for (String aKey : new HashSet(idmap.keySet())) {
                Object value = idmap.get(aKey);
                if (!(value instanceof Number)) continue;
                Number n = (Number)value;
                if (n.longValue() == me) {
                    if (aKey.equals(this.slingId)) {
                        foundMe = true;
                        continue;
                    }
                    this.logger.info("init: my clusterNodeId is already mapped to by another slingId, deleting entry: key=" + aKey + " mapped to " + value);
                    idmap.remove(aKey);
                    continue;
                }
                if (!aKey.equals(this.slingId)) continue;
                this.logger.info("init: my slingId is already mapped to by another clusterNodeId, deleting entry: key=" + aKey + " mapped to " + value);
                idmap.remove(aKey);
            }
            if (!foundMe) {
                this.logger.info("init: added the following mapping: slingId=" + this.slingId + " to discovery-lite id=" + me);
                idmap.put(this.slingId, me);
            } else {
                this.logger.info("init: mapping already existed, left unchanged: slingId=" + this.slingId + " to discovery-lite id=" + me);
            }
            resourceResolver.commit();
            this.me = me;
            this.initialized = true;
            this.notifyAll();
            boolean bl = true;
            return bl;
        }
    }

    public synchronized void clearCache() {
        if (!this.idMapCache.isEmpty()) {
            this.logger.debug("clearCache: clearing idmap cache");
            this.oldIdMapCache.clear();
            this.oldIdMapCache.putAll(this.idMapCache);
            this.idMapCache.clear();
        } else {
            this.logger.debug("clearCache: cache was already emtpy");
        }
        this.lastCacheInvalidation = System.currentTimeMillis();
    }

    public synchronized String toSlingId(int clusterNodeId, ResourceResolver resourceResolver) throws PersistenceException {
        String slingId;
        if (System.currentTimeMillis() - this.lastCacheInvalidation > 30000L) {
            this.clearCache();
        }
        if ((slingId = this.idMapCache.get(clusterNodeId)) != null) {
            return slingId;
        }
        this.logger.debug("toSlingId: cache miss, refreshing idmap cache");
        Map<Integer, String> readMap = this.readIdMap(resourceResolver);
        Set<Map.Entry<Integer, String>> newEntries = readMap.entrySet();
        for (Map.Entry<Integer, String> newEntry : newEntries) {
            String oldValue = this.oldIdMapCache.get(newEntry.getKey());
            if (oldValue == null || !oldValue.equals(newEntry.getValue())) {
                this.logger.info("toSlingId: mapping for " + newEntry.getKey() + " to " + newEntry.getValue() + " was newly added.");
            } else if (!oldValue.equals(newEntry.getValue())) {
                this.logger.info("toSlingId: mapping for " + newEntry.getKey() + " changed from " + oldValue + " to " + newEntry.getValue());
            }
            this.idMapCache.put(newEntry.getKey(), newEntry.getValue());
        }
        Set<Map.Entry<Integer, String>> oldEntries = this.oldIdMapCache.entrySet();
        for (Map.Entry<Integer, String> oldEntry : oldEntries) {
            if (this.idMapCache.containsKey(oldEntry.getKey())) continue;
            this.logger.info("toSlingId: mapping for " + oldEntry.getKey() + " to " + oldEntry.getValue() + " disappeared.");
        }
        return this.idMapCache.get(clusterNodeId);
    }

    private Map<Integer, String> readIdMap(ResourceResolver resourceResolver) throws PersistenceException {
        Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, this.getIdMapPath());
        ValueMap idmapValueMap = resource.adaptTo(ValueMap.class);
        HashMap<Integer, String> idmap = new HashMap<Integer, String>();
        for (String slingId : idmapValueMap.keySet()) {
            Object value = idmapValueMap.get(slingId);
            if (!(value instanceof Number)) continue;
            Number number = (Number)value;
            idmap.put(number.intValue(), slingId);
        }
        return idmap;
    }

    private String getIdMapPath() {
        return this.commonsConfig.getIdMapPath();
    }

    @Override
    public void onChange(List<ResourceChange> changes) {
        this.logger.debug("onChange: got notified of changes, clearing cache.");
        this.clearCache();
    }
}

