/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.sightly;

import java.util.Collection;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.HApiTypesCollection;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class TypesCollectionView
implements Use {
    private static final Logger LOG = LoggerFactory.getLogger(TypesCollectionView.class);
    private HApiUtil hapi;
    private HApiTypesCollection me;
    private String description;
    private SlingHttpServletRequest request;
    private SlingScriptHelper sling;
    private Resource resource;
    private ResourceResolver resourceResolver;

    @Override
    public void init(Bindings bindings) {
        this.request = (SlingHttpServletRequest)bindings.get("request");
        this.sling = (SlingScriptHelper)bindings.get("sling");
        this.resource = (Resource)bindings.get("resource");
        this.resourceResolver = this.request.getResourceResolver();
        try {
            this.activate();
        }
        catch (Exception e) {
            LOG.error("Failed to activate Use class", e);
        }
    }

    public void activate() throws Exception {
        this.hapi = this.sling.getService(HApiUtil.class);
        this.me = this.hapi.collectionFromPath(this.resourceResolver, this.resource.getPath());
        LOG.debug("me: {}  resource: {}", (Object)this.me, (Object)this.resource.getPath());
        this.description = this.me.getDescription();
    }

    public String getTitle() {
        return this.me.getFqdn();
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<HApiType> getTypes() {
        return this.me;
    }

    public boolean getHasTypes() {
        return this.getTypes().size() > 0;
    }
}

