/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.asm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.sax.XHTMLContentHandler;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class XHTMLClassVisitor
extends ClassVisitor {
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private Type type;
    private String packageName;

    public XHTMLClassVisitor(ContentHandler handler, Metadata metadata) {
        super(327680);
        this.xhtml = new XHTMLContentHandler(handler, metadata);
        this.metadata = metadata;
    }

    public void parse(InputStream stream) throws TikaException, SAXException, IOException {
        try {
            ClassReader reader = new ClassReader(stream);
            reader.accept((ClassVisitor)this, 5);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Failed to parse a Java class", e);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.type = Type.getObjectType((String)name);
        String className = this.type.getClassName();
        int dot = className.lastIndexOf(46);
        if (dot != -1) {
            this.packageName = className.substring(0, dot);
            className = className.substring(dot + 1);
        }
        this.metadata.set(TikaCoreProperties.TITLE, className);
        this.metadata.set("resourceName", className + ".class");
        try {
            this.xhtml.startDocument();
            this.xhtml.startElement("pre");
            if (this.packageName != null) {
                this.writeKeyword("package");
                this.xhtml.characters(" " + this.packageName + ";\n");
            }
            this.writeAccess(access);
            if (XHTMLClassVisitor.isSet(access, 512)) {
                this.writeKeyword("interface");
                this.writeSpace();
                this.writeType(this.type);
                this.writeSpace();
                this.writeInterfaces("extends", interfaces);
            } else if (XHTMLClassVisitor.isSet(access, 16384)) {
                this.writeKeyword("enum");
                this.writeSpace();
                this.writeType(this.type);
                this.writeSpace();
            } else {
                Type superType;
                this.writeKeyword("class");
                this.writeSpace();
                this.writeType(this.type);
                this.writeSpace();
                if (superName != null && !(superType = Type.getObjectType((String)superName)).getClassName().equals("java.lang.Object")) {
                    this.writeKeyword("extends");
                    this.writeSpace();
                    this.writeType(superType);
                    this.writeSpace();
                }
                this.writeInterfaces("implements", interfaces);
            }
            this.xhtml.characters("{\n");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInterfaces(String keyword, String[] interfaces) throws SAXException {
        if (interfaces != null && interfaces.length > 0) {
            this.writeKeyword(keyword);
            String separator = " ";
            for (String iface : interfaces) {
                this.xhtml.characters(separator);
                this.writeType(Type.getObjectType((String)iface));
                separator = ", ";
            }
            this.writeSpace();
        }
    }

    public void visitEnd() {
        try {
            this.xhtml.characters("}\n");
            this.xhtml.endElement("pre");
            this.xhtml.endDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!XHTMLClassVisitor.isSet(access, 4096)) {
            try {
                this.xhtml.characters("    ");
                this.writeAccess(access);
                this.writeType(Type.getType((String)desc));
                this.writeSpace();
                this.writeIdentifier(name);
                if (XHTMLClassVisitor.isSet(access, 8) && value != null) {
                    this.xhtml.characters(" = ");
                    this.xhtml.characters(value.toString());
                }
                this.writeSemicolon();
                this.writeNewline();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!XHTMLClassVisitor.isSet(access, 4096)) {
            try {
                this.xhtml.characters("    ");
                this.writeAccess(access);
                this.writeType(Type.getReturnType((String)desc));
                this.writeSpace();
                if ("<init>".equals(name)) {
                    this.writeType(this.type);
                } else {
                    this.writeIdentifier(name);
                }
                this.xhtml.characters("(");
                String separator = "";
                for (Type type : Type.getArgumentTypes((String)desc)) {
                    this.xhtml.characters(separator);
                    this.writeType(type);
                    separator = ", ";
                }
                this.xhtml.characters(")");
                if (exceptions != null && exceptions.length > 0) {
                    this.writeSpace();
                    this.writeKeyword("throws");
                    separator = " ";
                    for (String string : exceptions) {
                        this.xhtml.characters(separator);
                        this.writeType(Type.getObjectType((String)string));
                        separator = ", ";
                    }
                }
                this.writeSemicolon();
                this.writeNewline();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void writeIdentifier(String identifier) throws SAXException {
        this.xhtml.startElement("span", "class", "java-identifier");
        this.xhtml.characters(identifier);
        this.xhtml.endElement("span");
    }

    private void writeKeyword(String keyword) throws SAXException {
        this.xhtml.startElement("span", "class", "java-keyword");
        this.xhtml.characters(keyword);
        this.xhtml.endElement("span");
    }

    private void writeSemicolon() throws SAXException {
        this.xhtml.characters(";");
    }

    private void writeSpace() throws SAXException {
        this.xhtml.characters(" ");
    }

    private void writeNewline() throws SAXException {
        this.xhtml.characters("\n");
    }

    private void writeAccess(int access) throws SAXException {
        this.writeAccess(access, 2, "private");
        this.writeAccess(access, 4, "protected");
        this.writeAccess(access, 1, "public");
        this.writeAccess(access, 8, "static");
        this.writeAccess(access, 16, "final");
        this.writeAccess(access, 1024, "abstract");
        this.writeAccess(access, 32, "synchronized");
        this.writeAccess(access, 128, "transient");
        this.writeAccess(access, 64, "volatile");
        this.writeAccess(access, 256, "native");
    }

    private void writeAccess(int access, int code, String keyword) throws SAXException {
        if (XHTMLClassVisitor.isSet(access, code)) {
            this.writeKeyword(keyword);
            this.xhtml.characters(" ");
        }
    }

    private void writeType(Type type) throws SAXException {
        String name = type.getClassName();
        if (name.startsWith(this.packageName + ".")) {
            this.xhtml.characters(name.substring(this.packageName.length() + 1));
        } else if (name.startsWith("java.lang.")) {
            this.xhtml.characters(name.substring("java.lang.".length()));
        } else {
            this.xhtml.characters(name);
        }
    }

    private static boolean isSet(int value, int flag) {
        return (value & flag) != 0;
    }
}

