/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.FDField;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AbstractFDField
implements FDField {
    @Self
    protected SlingHttpServletRequest slingRequest;
    @SlingObject
    protected Resource resource;
    @ScriptVariable
    protected ValueMap properties;
    protected I18n i18n;

    @PostConstruct
    private void initModel() {
        this.i18n = GuideUtils.getI18n(this.slingRequest, this.resource);
    }

    @Override
    @Nonnull
    public String getTitle() {
        return this.externalize(this.properties.get("jcr:title", ""));
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    @Nonnull
    public String getName() {
        return StringEscapeUtils.escapeHtml4(NodeStructureUtils.getGuideName(this.resource));
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.externalize(this.properties.get("jcr:description", ""));
    }

    @Override
    @Nonnull
    public String getId() {
        return NodeStructureUtils.getGuideNodeHtmlId(this.resource);
    }

    @Override
    @Nonnull
    public String getGuideFieldType() {
        return this.properties.get("guideNodeClass", "");
    }

    @Nullable
    protected String externalize(@Nonnull String key) {
        boolean editMode;
        if (StringUtils.isBlank(key)) {
            return null;
        }
        boolean bl = editMode = WCMMode.fromRequest(this.slingRequest) == WCMMode.EDIT || WCMMode.fromRequest(this.slingRequest) == WCMMode.DESIGN;
        if (editMode) {
            return key;
        }
        return GuideUtils.translateOrReturnOriginal(key, this.i18n);
    }
}

