/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import org.apache.commons.lang.StringUtils;

public final class FDVersion {
    private final int majorVersion;
    private final int minorVersion;

    public FDVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public FDVersion(String version) {
        String[] split = StringUtils.split(version, ".");
        if (split != null && split.length > 1) {
            this.majorVersion = Integer.parseInt(split[0]);
            this.minorVersion = Integer.parseInt(split[1]);
        } else {
            this.majorVersion = 0;
            this.minorVersion = 0;
        }
    }

    public int compareTo(FDVersion version) {
        return FDVersion.compare(this, version);
    }

    public static int compare(FDVersion v1, FDVersion v2) {
        return v1.majorVersion == v2.majorVersion ? v1.minorVersion - v2.minorVersion : v1.majorVersion - v2.majorVersion;
    }

    public static int compare(String v1, String v2) {
        FDVersion gv1 = new FDVersion(v1);
        FDVersion gv2 = new FDVersion(v2);
        return FDVersion.compare(gv1, gv2);
    }

    public String toString() {
        return String.valueOf(this.majorVersion) + "." + String.valueOf(this.minorVersion);
    }
}

