/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import java.util.HashMap;
import java.util.Map;

public enum SignerInfoSource {
    FORM("form"),
    USER_PROFILE("userProfile"),
    TYPED("typed");

    private static final Map<String, SignerInfoSource> valueLookup;
    private String value;

    private SignerInfoSource(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    public static SignerInfoSource get(String value) {
        return valueLookup.get(value);
    }

    static {
        valueLookup = new HashMap<String, SignerInfoSource>();
        for (SignerInfoSource signerInfoSource : SignerInfoSource.values()) {
            valueLookup.put(signerInfoSource.getValue(), signerInfoSource);
        }
    }
}

